/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Logger;

public abstract class IvFMLIntercommHandler {
    private Logger logger;
    private String modOwnerID;
    private Object modInstance;

    protected IvFMLIntercommHandler(Logger logger, String modOwnerID, Object modInstance) {
        this.logger = logger;
        this.modOwnerID = modOwnerID;
        this.modInstance = modInstance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getModOwnerID() {
        return this.modOwnerID;
    }

    public void setModOwnerID(String modOwnerID) {
        this.modOwnerID = modOwnerID;
    }

    public Object getModInstance() {
        return this.modInstance;
    }

    public void setModInstance(Object modInstance) {
        this.modInstance = modInstance;
    }

    public void handleMessages(boolean server, boolean runtime) {
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)this.modInstance)) {
            this.onIMCMessage(message, server, true);
        }
    }

    public void onIMCMessage(FMLInterModComms.IMCMessage message, boolean server, boolean runtime) {
        try {
            boolean didHandle = this.handleMessage(message, server, runtime);
            if (!didHandle) {
                this.logger.warn("Could not handle message with key '" + message.key + "' of type '" + message.getMessageType().getName() + "'");
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception on message with key '" + message.key + "' of type '" + message.getMessageType().getName() + "'");
            ex.printStackTrace();
        }
    }

    protected abstract boolean handleMessage(FMLInterModComms.IMCMessage var1, boolean var2, boolean var3);

    protected boolean isMessage(String key, FMLInterModComms.IMCMessage message, Class expectedType) {
        if (key.equals(message.key)) {
            if (message.getMessageType().isAssignableFrom(expectedType)) {
                return true;
            }
            this.faultyMessage(message, expectedType);
        }
        return false;
    }

    protected Entity getEntity(NBTTagCompound compound, boolean server) {
        return this.getEntity(compound, "worldID", "entityID", server);
    }

    protected Entity getEntity(NBTTagCompound compound, String worldKey, String entityKey, boolean server) {
        if (!server) {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e(entityKey));
        }
        return FMLCommonHandler.instance().getSidedDelegate().getServer().func_71218_a(compound.func_74762_e(worldKey)).func_73045_a(compound.func_74762_e(entityKey));
    }

    protected boolean sendReply(FMLInterModComms.IMCMessage message, String value) {
        if (message.getSender() == null) {
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)this.modOwnerID, (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (String)value);
        return true;
    }

    protected boolean sendReply(FMLInterModComms.IMCMessage message, NBTTagCompound value) {
        if (message.getSender() == null) {
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)this.modOwnerID, (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (NBTTagCompound)value);
        return true;
    }

    protected boolean sendReply(FMLInterModComms.IMCMessage message, ItemStack value) {
        if (message.getSender() == null) {
            this.logger.error("Message error! Could not reply to message with key '" + message.key + "' - No sender found");
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)this.modOwnerID, (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (ItemStack)value);
        return true;
    }

    private void faultyMessage(FMLInterModComms.IMCMessage message, Class expectedType) {
        this.logger.error("Got message with key '" + message.key + "' of type '" + message.getMessageType().getName() + "'; Expected type: '" + expectedType.getName() + "'");
    }
}

