/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.PlacedMazeComponent;
import ivorius.ivtoolkit.maze.components.WeightedMazeComponent;
import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MultiMazeComponent<M extends WeightedMazeComponent<C>, C>
implements WeightedMazeComponent<C> {
    private final List<M> components;
    private final double weight;

    public MultiMazeComponent(List<M> components) {
        this.components = components;
        this.weight = components.stream().mapToDouble(WeightedSelector.Item::getWeight).sum();
    }

    public M first() {
        return (M)((WeightedMazeComponent)this.components.get(0));
    }

    @Override
    public Set<MazeRoom> rooms() {
        return this.first().rooms();
    }

    @Override
    public Map<MazePassage, C> exits() {
        return this.first().exits();
    }

    @Override
    public Multimap<MazePassage, MazePassage> reachability() {
        return this.first().reachability();
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public PlacedMazeComponent<M, C> place(MazeRoom shift, Random random) {
        return new PlacedMazeComponent((WeightedMazeComponent)WeightedSelector.selectItem(random, this.components), shift);
    }
}

