/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;

public class Directions {
    public static final EnumFacing[] HORIZONTAL = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    public static final EnumFacing[] X_AXIS = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST};
    public static final EnumFacing[] Y_AXIS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    public static final EnumFacing[] Z_AXIS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};

    @Nullable
    public static Integer getHorizontalClockwiseRotations(EnumFacing source, EnumFacing dest, boolean mirrorX) {
        if (source == dest) {
            return mirrorX && ArrayUtils.contains((Object[])X_AXIS, (Object)dest) ? 2 : 0;
        }
        int arrayIndexSrc = ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)source);
        int arrayIndexDst = ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)dest);
        if (arrayIndexSrc >= 0 && arrayIndexDst >= 0) {
            int mirrorRotations = mirrorX && ArrayUtils.contains((Object[])X_AXIS, (Object)source) ? 2 : 0;
            return (arrayIndexDst - arrayIndexSrc + mirrorRotations + HORIZONTAL.length) % HORIZONTAL.length;
        }
        return null;
    }

    public static EnumFacing rotate(EnumFacing direction, AxisAlignedTransform2D transform) {
        if (direction == EnumFacing.UP || direction == EnumFacing.DOWN) {
            return direction;
        }
        int rotations = transform.getRotation();
        if (transform.isMirrorX() && ArrayUtils.contains((Object[])X_AXIS, (Object)direction)) {
            rotations += 2;
        }
        return HORIZONTAL[(ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)direction) + rotations) % HORIZONTAL.length];
    }

    public static EnumFacing deserialize(String id) {
        EnumFacing direction = (EnumFacing)IvGsonHelper.enumForNameIgnoreCase((String)id, (Enum[])EnumFacing.values());
        return direction != null ? direction : EnumFacing.NORTH;
    }

    public static EnumFacing deserializeHorizontal(String id) {
        EnumFacing direction = (EnumFacing)IvGsonHelper.enumForNameIgnoreCase((String)id, (Enum[])HORIZONTAL);
        return direction != null ? direction : EnumFacing.NORTH;
    }

    public static String serialize(EnumFacing direction) {
        return IvGsonHelper.serializedName((Enum)direction);
    }

    public static EnumFacing getDirectionFromVRotation(int front) {
        switch (front) {
            default: {
                return EnumFacing.SOUTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: 
        }
        return EnumFacing.WEST;
    }
}

