/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockPositions;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class BlockArea
implements Iterable<BlockPos> {
    private BlockPos point1;
    private BlockPos point2;

    public BlockArea(BlockPos point1, BlockPos point2) {
        this.point1 = point1;
        this.point2 = point2;
    }

    public static BlockArea areaFromSize(BlockPos coord, int[] size) {
        if (size[0] <= 0 || size[1] <= 0 || size[2] <= 0) {
            throw new IllegalArgumentException();
        }
        return new BlockArea(coord, new BlockPos(coord.func_177958_n() + size[0] - 1, coord.func_177956_o() + size[1] - 1, coord.func_177952_p() + size[2] - 1));
    }

    public BlockPos getPoint1() {
        return this.point1;
    }

    public void setPoint1(BlockPos point1) {
        this.point1 = point1;
    }

    public BlockPos getPoint2() {
        return this.point2;
    }

    public void setPoint2(BlockPos point2) {
        this.point2 = point2;
    }

    public BlockPos getLowerCorner() {
        return BlockPositions.getLowerCorner(this.point1, this.point2);
    }

    public BlockPos getHigherCorner() {
        return BlockPositions.getHigherCorner(this.point1, this.point2);
    }

    public int[] areaSize() {
        BlockPos lower = this.getLowerCorner();
        BlockPos higher = this.getHigherCorner();
        return new int[]{higher.func_177958_n() - lower.func_177958_n() + 1, higher.func_177956_o() - lower.func_177956_o() + 1, higher.func_177952_p() - lower.func_177952_p() + 1};
    }

    public boolean contains(BlockPos coord) {
        BlockPos lower = this.getLowerCorner();
        BlockPos higher = this.getHigherCorner();
        return coord.func_177958_n() >= lower.func_177958_n() && coord.func_177956_o() >= lower.func_177956_o() && coord.func_177952_p() >= lower.func_177952_p() && coord.func_177958_n() <= higher.func_177958_n() && coord.func_177956_o() <= higher.func_177956_o() && coord.func_177952_p() <= higher.func_177952_p();
    }

    public AxisAlignedBB asAxisAlignedBB() {
        return new AxisAlignedBB(this.getLowerCorner(), this.getHigherCorner().func_177982_a(1, 1, 1));
    }

    public Stream<BlockPos> stream() {
        return BlockAreas.streamPositions(this);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return this.stream().iterator();
    }
}

