/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.core.helper.NbtHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class IngredientPredicateItemStackNbt
extends IngredientPredicate<ItemStack, Integer> {
    private final boolean blacklist;
    private final boolean requireNbt;
    private final boolean subset;
    private final NBTTagCompound tag;
    private final boolean recursive;
    private final boolean superset;

    public IngredientPredicateItemStackNbt(boolean blacklist, int amount, boolean exactAmount, boolean requireNbt, boolean subset, NBTTagCompound tag, boolean recursive, boolean superset) {
        super(IngredientComponent.ITEMSTACK, blacklist, false, amount, exactAmount);
        this.blacklist = blacklist;
        this.requireNbt = requireNbt;
        this.subset = subset;
        this.tag = tag;
        this.recursive = recursive;
        this.superset = superset;
    }

    @Override
    public boolean test(@Nullable ItemStack input) {
        boolean ret;
        if (!input.func_77942_o() && this.requireNbt) {
            return this.isBlacklist();
        }
        NBTTagCompound itemTag = input.func_77942_o() ? input.func_77978_p() : new NBTTagCompound();
        boolean bl = ret = !(this.subset && !NbtHelpers.nbtMatchesSubset((NBTTagCompound)this.tag, (NBTTagCompound)itemTag, (boolean)this.recursive) || this.superset && !NbtHelpers.nbtMatchesSubset((NBTTagCompound)itemTag, (NBTTagCompound)this.tag, (boolean)this.recursive));
        if (this.blacklist) {
            ret = !ret;
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicateItemStackNbt)) {
            return false;
        }
        IngredientPredicateItemStackNbt that = (IngredientPredicateItemStackNbt)obj;
        return super.equals(obj) && this.blacklist == that.blacklist && this.requireNbt == that.requireNbt && this.subset == that.subset && this.tag.equals((Object)that.tag) && this.recursive == that.recursive && this.superset == that.superset;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.blacklist ? 1 : 0) << 1 ^ (this.requireNbt ? 1 : 0) << 2 ^ (this.subset ? 1 : 0) << 3 ^ this.tag.hashCode() << 4 ^ (this.recursive ? 1 : 0) << 5 ^ (this.superset ? 1 : 0) << 6;
    }
}

