/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockSqueezer;

public class SqueezerRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<BlockSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent, SqueezerRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final List<List<ItemStack>> outputItems;
    private final FluidStack outputFluid;
    private final List<Float> outputChances;

    public SqueezerRecipeJEI(IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe) {
        super(recipe);
        this.inputItem = ((IngredientRecipeComponent)recipe.getInput()).getItemStacks();
        this.outputItems = ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getSubIngredientComponents().stream().map(IngredientRecipeComponent::getItemStacks).collect(Collectors.toList());
        this.outputFluid = ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack();
        this.outputChances = ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getSubIngredientComponents().stream().map(IngredientRecipeComponent::getChance).collect(Collectors.toList());
    }

    protected SqueezerRecipeJEI() {
        super(null);
        this.inputItem = null;
        this.outputItems = null;
        this.outputFluid = null;
        this.outputChances = null;
    }

    protected IRecipeRegistry<BlockSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> getRecipeRegistry() {
        return BlockSqueezer.getInstance().getRecipeRegistry();
    }

    protected SqueezerRecipeJEI newInstance(IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> input) {
        return new SqueezerRecipeJEI(input);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputItem());
        ingredients.setOutputLists(ItemStack.class, this.getOutputItems());
        ingredients.setOutput(FluidStack.class, (Object)this.getOutputFluid());
    }

    public static List<SqueezerRecipeJEI> getAllRecipes() {
        return new SqueezerRecipeJEI().createAllRecipes();
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public List<List<ItemStack>> getOutputItems() {
        return this.outputItems;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public List<Float> getOutputChances() {
        return this.outputChances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqueezerRecipeJEI)) {
            return false;
        }
        SqueezerRecipeJEI other = (SqueezerRecipeJEI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<ItemStack> this$inputItem = this.getInputItem();
        List<ItemStack> other$inputItem = other.getInputItem();
        if (this$inputItem == null ? other$inputItem != null : !((Object)this$inputItem).equals(other$inputItem)) {
            return false;
        }
        List<List<ItemStack>> this$outputItems = this.getOutputItems();
        List<List<ItemStack>> other$outputItems = other.getOutputItems();
        if (this$outputItems == null ? other$outputItems != null : !((Object)this$outputItems).equals(other$outputItems)) {
            return false;
        }
        FluidStack this$outputFluid = this.getOutputFluid();
        FluidStack other$outputFluid = other.getOutputFluid();
        if (this$outputFluid == null ? other$outputFluid != null : !this$outputFluid.equals(other$outputFluid)) {
            return false;
        }
        List<Float> this$outputChances = this.getOutputChances();
        List<Float> other$outputChances = other.getOutputChances();
        return !(this$outputChances == null ? other$outputChances != null : !((Object)this$outputChances).equals(other$outputChances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqueezerRecipeJEI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ItemStack> $inputItem = this.getInputItem();
        result = result * 59 + ($inputItem == null ? 0 : ((Object)$inputItem).hashCode());
        List<List<ItemStack>> $outputItems = this.getOutputItems();
        result = result * 59 + ($outputItems == null ? 0 : ((Object)$outputItems).hashCode());
        FluidStack $outputFluid = this.getOutputFluid();
        result = result * 59 + ($outputFluid == null ? 0 : $outputFluid.hashCode());
        List<Float> $outputChances = this.getOutputChances();
        result = result * 59 + ($outputChances == null ? 0 : ((Object)$outputChances).hashCode());
        return result;
    }

    public String toString() {
        return "SqueezerRecipeJEI(inputItem=" + this.getInputItem() + ", outputItems=" + this.getOutputItems() + ", outputFluid=" + this.getOutputFluid() + ", outputChances=" + this.getOutputChances() + ")";
    }
}

