/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueCastMappings;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeCategoryBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeCategoryNumber
extends ValueTypeCategoryBase<IValue>
implements IValueTypeNamed<IValue> {
    private static final IValueTypeNumber[] ELEMENTS = new IValueTypeNumber[]{ValueTypes.INTEGER, ValueTypes.DOUBLE, ValueTypes.LONG};
    private static final Map<IValueTypeNumber, Integer> INVERTED_ELEMENTS = Collections.unmodifiableMap(ValueTypeCategoryNumber.constructInvertedArray(ELEMENTS));

    public ValueTypeCategoryNumber() {
        super("number", Helpers.RGBToInt((int)243, (int)245, (int)4), TextFormatting.GOLD.toString(), Sets.newHashSet((Object[])ELEMENTS), IValue.class);
    }

    private static Map<IValueTypeNumber, Integer> constructInvertedArray(IValueTypeNumber[] elements) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < elements.length; ++i) {
            map.put(elements[i], i);
        }
        return map;
    }

    public IValueTypeNumber getLowestType(IValueTypeNumber ... types) {
        IValueTypeNumber first = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == first) continue;
            int maxIndex = -1;
            for (int j = 0; j < types.length; ++j) {
                IValueTypeNumber v = types[j];
                if (v == null) continue;
                maxIndex = Math.max(maxIndex, INVERTED_ELEMENTS.get(v));
            }
            return ELEMENTS[maxIndex];
        }
        return first;
    }

    protected IValue castValue(IValueTypeNumber type, IValue value) throws IValueCastRegistry.ValueCastException {
        if (value.getType() == type) {
            return value;
        }
        return ValueCastMappings.REGISTRY.cast(type, value);
    }

    protected IValueTypeNumber getType(IVariable v) throws EvaluationException {
        IValueType valueType = v.getType();
        if (!(valueType instanceof IValueTypeNumber)) {
            valueType = v.getValue().getType();
        }
        return (IValueTypeNumber)valueType;
    }

    public IValue add(IVariable a, IVariable b) throws EvaluationException {
        IValue av;
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        if (type.isZero(av = this.castValue(type, (IValue)a.getValue()))) {
            return this.castValue(type, (IValue)b.getValue());
        }
        IValue bv = this.castValue(type, (IValue)b.getValue());
        if (type.isZero(bv)) {
            return av;
        }
        return type.add(av, bv);
    }

    public IValue subtract(IVariable a, IVariable b) throws EvaluationException {
        IValue bv;
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        if (type.isZero(bv = this.castValue(type, (IValue)b.getValue()))) {
            return this.castValue(type, (IValue)a.getValue());
        }
        IValue av = this.castValue(type, (IValue)a.getValue());
        return type.subtract(av, bv);
    }

    public IValue multiply(IVariable a, IVariable b) throws EvaluationException {
        IValue av;
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        if (type.isZero(av = this.castValue(type, (IValue)a.getValue()))) {
            return av;
        }
        if (type.isOne(av)) {
            return this.castValue(type, (IValue)b.getValue());
        }
        IValue bv = this.castValue(type, (IValue)b.getValue());
        if (type.isOne(bv)) {
            return av;
        }
        return type.multiply(av, bv);
    }

    public IValue divide(IVariable a, IVariable b) throws EvaluationException {
        IValue bv;
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        if (type.isZero(bv = this.castValue(type, (IValue)b.getValue()))) {
            throw new EvaluationException("Division by zero");
        }
        if (type.isOne(bv)) {
            return a.getValue();
        }
        IValue av = this.castValue(type, (IValue)a.getValue());
        return type.divide(av, bv);
    }

    public IValue max(IVariable a, IVariable b) throws EvaluationException {
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        return type.max(this.castValue(type, (IValue)a.getValue()), this.castValue(type, (IValue)b.getValue()));
    }

    public IValue min(IVariable a, IVariable b) throws EvaluationException {
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        return type.min(this.castValue(type, (IValue)a.getValue()), this.castValue(type, (IValue)b.getValue()));
    }

    public boolean greaterThan(IVariable a, IVariable b) throws EvaluationException {
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        return type.greaterThan(this.castValue(type, (IValue)a.getValue()), this.castValue(type, (IValue)b.getValue()));
    }

    public boolean lessThan(IVariable a, IVariable b) throws EvaluationException {
        IValueTypeNumber type = this.getLowestType(this.getType(a), this.getType(b));
        return type.lessThan(this.castValue(type, (IValue)a.getValue()), this.castValue(type, (IValue)b.getValue()));
    }

    public ValueTypeInteger.ValueInteger round(IVariable a) throws EvaluationException {
        IValueTypeNumber type = this.getType(a);
        return type.round(this.castValue(type, (IValue)a.getValue()));
    }

    public ValueTypeInteger.ValueInteger ceil(IVariable a) throws EvaluationException {
        IValueTypeNumber type = this.getType(a);
        return type.ceil(this.castValue(type, (IValue)a.getValue()));
    }

    public ValueTypeInteger.ValueInteger floor(IVariable a) throws EvaluationException {
        IValueTypeNumber type = this.getType(a);
        return type.floor(this.castValue(type, (IValue)a.getValue()));
    }

    @Override
    public String getName(IValue a) {
        return ((IValueTypeNamed)a.getType()).getName(a);
    }
}

