/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;

public class ValueObjectTypeRecipe
extends ValueObjectTypeBase<ValueRecipe>
implements IValueTypeNamed<ValueRecipe>,
IValueTypeNullable<ValueRecipe> {
    public ValueObjectTypeRecipe() {
        super("recipe", ValueRecipe.class);
    }

    @Override
    public ValueRecipe getDefault() {
        return ValueRecipe.of(null);
    }

    @Override
    public String toCompactString(ValueRecipe value) {
        if (value.getRawValue().isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)value.getRawValue().get();
            StringBuilder sb = new StringBuilder();
            sb.append(ValueObjectTypeIngredients.ingredientsToString(recipe.getOutput()));
            sb.append(" <- ");
            for (IngredientComponent component : recipe.getInputComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (IPrototypedIngredientAlternatives instances : recipe.getInputs(component)) {
                    IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)Iterables.getFirst((Iterable)instances.getAlternatives(), null);
                    Object v = prototypedIngredient == null ? handler.getValueType().getDefault() : handler.toValue(prototypedIngredient.getPrototype());
                    sb.append(handler.toCompactString(v));
                    sb.append(", ");
                }
            }
            String str = sb.toString();
            return str.length() >= 2 ? str.substring(0, str.length() - 2) : "";
        }
        return "";
    }

    @Override
    public String serialize(ValueRecipe value) {
        if (!value.getRawValue().isPresent()) {
            return "";
        }
        return IRecipeDefinition.serialize((IRecipeDefinition)((IRecipeDefinition)value.getRawValue().get())).toString();
    }

    @Override
    public ValueRecipe deserialize(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return ValueRecipe.of(null);
        }
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            return ValueRecipe.of((IRecipeDefinition)IRecipeDefinition.deserialize((NBTTagCompound)tag));
        }
        catch (NBTException e) {
            return ValueRecipe.of(null);
        }
    }

    @Override
    public String getName(ValueRecipe a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueRecipe a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeRecipeLPElement();
    }

    public static class ValueRecipe
    extends ValueOptionalBase<IRecipeDefinition> {
        private ValueRecipe(IRecipeDefinition recipe) {
            super(ValueTypes.OBJECT_RECIPE, recipe);
        }

        public static ValueRecipe of(IRecipeDefinition recipe) {
            return new ValueRecipe(recipe);
        }

        @Override
        protected boolean isEqual(IRecipeDefinition a, IRecipeDefinition b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeRecipe.ValueRecipe()";
        }
    }
}

