/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.path;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementDefault;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;

public abstract class PathElementCable
extends PathElementDefault {
    protected abstract ICable getCable();

    @Override
    public Set<ISidedPathElement> getReachableElements() {
        HashSet elements = Sets.newHashSet();
        BlockPos pos = this.getPosition().getBlockPos();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.getCable().isConnected(side)) continue;
            BlockPos posOffset = pos.func_177972_a(side);
            EnumFacing pathElementSide = side.func_176734_d();
            IPathElement pathElement = (IPathElement)TileHelpers.getCapability((World)this.getPosition().getWorld(), (BlockPos)posOffset, (EnumFacing)pathElementSide, PathElementConfig.CAPABILITY);
            if (pathElement == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The position at %s was incorrectly marked as reachable as path element by %s at %s side %s.", posOffset, this.getCable(), pos, side));
                continue;
            }
            elements.add(SidedPathElement.of(pathElement, pathElementSide));
        }
        return elements;
    }
}

