/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static NBTTagList invToNBT(IItemHandler itemHandler, int amount) {
        NBTTagList nbtTagList = new NBTTagList();
        List<ItemStack> compressed = InventoryUtils.compressInventory(itemHandler);
        for (int i = 0; i < compressed.size() && i <= amount; ++i) {
            ItemStack stack = compressed.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            InventoryUtils.writeStack(stack, itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        return nbtTagList;
    }

    public static void populateInv(IItemHandlerModifiable itemHandler, NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= itemHandler.getSlots()) continue;
            itemHandler.setStackInSlot(slot, InventoryUtils.readStack(itemTags));
        }
    }

    public static void writeStack(ItemStack stack, NBTTagCompound tagCompound) {
        stack.func_77955_b(tagCompound);
        tagCompound.func_74768_a("CountI", stack.func_190916_E());
    }

    public static ItemStack readStack(NBTTagCompound tagCompound) {
        ItemStack stack = new ItemStack(tagCompound);
        stack.func_190920_e(tagCompound.func_74762_e("CountI"));
        return stack;
    }

    public static List<ItemStack> compressInventory(IItemHandler itemHandler) {
        ArrayList<ItemStack> compressed = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            InventoryUtils.addStack(compressed, stack);
        }
        return compressed;
    }

    public static void addStack(List<ItemStack> stacks, ItemStack stack) {
        for (ItemStack invStack : stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)invStack, (ItemStack)stack)) continue;
            invStack.func_190917_f(stack.func_190916_E());
            return;
        }
        stacks.add(stack.func_77946_l());
    }
}

