/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AABBUtils {
    public static boolean almostEqual(double a, double b) {
        return a - b > -1.0E-4 && a - b < 1.0E-4;
    }

    public static boolean almostEquals(double a, double b, double precision) {
        return a - b > -precision && a - b < precision;
    }

    public static Vec3d randomPosWithin(AxisAlignedBB aabb, Random rng) {
        double x = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * rng.nextDouble();
        double y = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * rng.nextDouble();
        double z = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * rng.nextDouble();
        return new Vec3d(x, y, z);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, Rotation rotationIn) {
        switch (rotationIn) {
            default: {
                return aabb;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, -aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-aabb.field_72340_a, aabb.field_72338_b, -aabb.field_72339_c, -aabb.field_72336_d, aabb.field_72337_e, -aabb.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, -aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, -aabb.field_72334_f);
    }

    public static AxisAlignedBB normalize(AxisAlignedBB aabb) {
        return aabb.func_72317_d(-aabb.field_72340_a, -aabb.field_72338_b, -aabb.field_72339_c);
    }

    public static AxisAlignedBB partial(AxisAlignedBB prev, AxisAlignedBB cur, float partialTicks) {
        double x1 = prev.field_72340_a + (cur.field_72340_a - prev.field_72340_a) * (double)partialTicks;
        double y1 = prev.field_72338_b + (cur.field_72338_b - prev.field_72338_b) * (double)partialTicks;
        double z1 = prev.field_72339_c + (cur.field_72339_c - prev.field_72339_c) * (double)partialTicks;
        double x2 = prev.field_72336_d + (cur.field_72336_d - prev.field_72336_d) * (double)partialTicks;
        double y2 = prev.field_72337_e + (cur.field_72337_e - prev.field_72337_e) * (double)partialTicks;
        double z2 = prev.field_72334_f + (cur.field_72334_f - prev.field_72334_f) * (double)partialTicks;
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public static AxisAlignedBB extrudeGravity(AxisAlignedBB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.func_72314_b((double)(-ay) * (aabb.field_72336_d - aabb.field_72340_a) / 2.0, (double)ay * (aabb.field_72337_e - aabb.field_72338_b) / 2.0, (double)(-ay) * (aabb.field_72334_f - aabb.field_72339_c) / 2.0).func_72317_d(0.0, (double)(-ySpeed) * (aabb.field_72337_e - aabb.field_72338_b) / 2.0, 0.0);
    }

    public static void cut(AxisAlignedBB box, AxisAlignedBB knife, List<AxisAlignedBB> intoList) {
        boolean ea2;
        boolean ea1;
        if (!box.func_72326_a(knife)) {
            intoList.add(box);
            return;
        }
        AxisAlignedBB inter = box.func_191500_a(knife);
        if (!AABBUtils.almostEqual(box.field_72338_b, inter.field_72338_b)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, inter.field_72338_b, box.field_72334_f));
        }
        if (!AABBUtils.almostEqual(box.field_72337_e, inter.field_72337_e)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f));
        }
        if (ea1 = !AABBUtils.almostEqual(box.field_72336_d, inter.field_72336_d)) {
            intoList.add(new AxisAlignedBB(inter.field_72336_d, inter.field_72338_b, box.field_72339_c, box.field_72336_d, inter.field_72337_e, inter.field_72334_f));
        }
        if (ea2 = !AABBUtils.almostEqual(box.field_72334_f, inter.field_72334_f)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, inter.field_72334_f, inter.field_72336_d, inter.field_72337_e, box.field_72334_f));
        }
        if (ea1 && ea2) {
            intoList.add(new AxisAlignedBB(inter.field_72336_d, inter.field_72338_b, inter.field_72334_f, box.field_72336_d, inter.field_72337_e, box.field_72334_f));
        }
        if (ea1 = !AABBUtils.almostEqual(box.field_72339_c, inter.field_72339_c)) {
            intoList.add(new AxisAlignedBB(inter.field_72340_a, inter.field_72338_b, box.field_72339_c, inter.field_72336_d, inter.field_72337_e, inter.field_72339_c));
        }
        if (ea2 = !AABBUtils.almostEqual(box.field_72340_a, inter.field_72340_a)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, inter.field_72339_c, inter.field_72340_a, inter.field_72337_e, inter.field_72334_f));
        }
        if (ea1 || ea2) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, box.field_72339_c, inter.field_72340_a, inter.field_72337_e, inter.field_72339_c));
        }
    }

    public static Vec3d getCenter(AxisAlignedBB aabb) {
        return new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
    }

    public static class Line
    implements ILinable {
        public static final double SPATIAL_PRECISION = 1.0E-5;
        public final Vec3d a;
        public final Vec3d b;

        public Line(Vec3d a, Vec3d b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            return Line.almostEquals(this.a, line.a, 1.0E-5) && Line.almostEquals(this.b, line.b, 1.0E-5) || Line.almostEquals(this.a, line.b, 1.0E-5) && Line.almostEquals(this.b, line.a, 1.0E-5);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public String toString() {
            return "Line{start=" + this.a + ", end=" + this.b + '}';
        }

        public static boolean almostEquals(Vec3d a, Vec3d b, double precision) {
            return AABBUtils.almostEquals(a.field_72450_a, b.field_72450_a, precision) && AABBUtils.almostEquals(a.field_72448_b, b.field_72448_b, precision) && AABBUtils.almostEquals(a.field_72449_c, b.field_72449_c, precision);
        }

        public Line offset(double x, double y, double z) {
            return new Line(this.a.func_72441_c(x, y, z), this.b.func_72441_c(x, y, z));
        }

        public Vec3d center() {
            return new Vec3d((this.a.field_72450_a + this.b.field_72450_a) / 2.0, (this.a.field_72448_b + this.b.field_72448_b) / 2.0, (this.a.field_72449_c + this.b.field_72449_c) / 2.0);
        }

        public Line expandFrom(Vec3d center, double expand) {
            Vec3d newA = this.a.func_178788_d(center).func_72432_b().func_186678_a(expand);
            Vec3d newB = this.b.func_178788_d(center).func_72432_b().func_186678_a(expand);
            return new Line(this.a.func_178787_e(newA), this.b.func_178787_e(newB));
        }

        public static Stream<Line> of(AxisAlignedBB aabb) {
            Stream.Builder<Line> lines = Stream.builder();
            Vec3d p1 = new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
            Vec3d p2 = new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
            Vec3d p3 = new Vec3d(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
            Vec3d p4 = new Vec3d(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
            Vec3d p5 = new Vec3d(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
            Vec3d p6 = new Vec3d(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
            Vec3d p7 = new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
            Vec3d p8 = new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            lines.add(new Line(p1, p2));
            lines.add(new Line(p1, p3));
            lines.add(new Line(p1, p5));
            lines.add(new Line(p2, p4));
            lines.add(new Line(p2, p6));
            lines.add(new Line(p3, p4));
            lines.add(new Line(p3, p7));
            lines.add(new Line(p5, p6));
            lines.add(new Line(p5, p7));
            lines.add(new Line(p8, p4));
            lines.add(new Line(p8, p6));
            lines.add(new Line(p8, p7));
            return lines.build();
        }

        public static List<Line> of(AxisAlignedBB ... aabbs) {
            return Line.of(Arrays.asList(aabbs));
        }

        public static <T> List<Line> of(Function<T, AxisAlignedBB> aabb, T ... aabbs) {
            return Line.of(aabb, Arrays.asList(aabbs));
        }

        public static <T> List<Line> of(Function<T, AxisAlignedBB> aabb, Iterable<T> aabbs) {
            return Line.dedupe(StreamSupport.stream(aabbs.spliterator(), false).map(aabb).flatMap(Line::of));
        }

        public static List<Line> of(Iterable<AxisAlignedBB> aabbs) {
            return Line.dedupe(StreamSupport.stream(aabbs.spliterator(), false).flatMap(Line::of));
        }

        public static List<Line> dedupe(Iterable<Line> aabbs) {
            return Line.dedupe(StreamSupport.stream(aabbs.spliterator(), false));
        }

        public static List<Line> dedupe(Stream<Line> aabbs) {
            ArrayList<Line> lines = new ArrayList<Line>();
            ArrayList dna = new ArrayList();
            StreamSupport.stream(aabbs.spliterator(), false).filter(ln -> !dna.contains(ln)).forEach(ln -> {
                if (!lines.contains(ln)) {
                    lines.add((Line)ln);
                } else {
                    dna.add(ln);
                    lines.remove(ln);
                }
            });
            return lines;
        }

        public static List<Line> grow(List<Line> lines, double expand) {
            Vec3d center = Line.getCenter(lines);
            lines = new ArrayList<Line>(lines);
            for (int i = 0; i < lines.size(); ++i) {
                Line origin = lines.get(i);
                lines.set(i, origin.expandFrom(center, expand));
            }
            return lines;
        }

        public static Vec3d getCenter(List<Line> lines) {
            if (lines.isEmpty()) {
                return null;
            }
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (Line ln : lines) {
                Vec3d c = ln.center();
                x += c.field_72450_a;
                y += c.field_72448_b;
                z += c.field_72449_c;
            }
            return new Vec3d(x / (double)lines.size(), y / (double)lines.size(), z / (double)lines.size());
        }

        @Override
        public List<Line> asLines() {
            return Collections.singletonList(this);
        }

        @SideOnly(value=Side.CLIENT)
        public static class LineRenderer {
            @SideOnly(value=Side.CLIENT)
            public static void drawBoundingBox(Stream<Line> lines, float red, float green, float blue, float alpha) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                LineRenderer.drawBoundingBox(bufferbuilder, lines, red, green, blue, alpha);
                tessellator.func_78381_a();
            }

            @SideOnly(value=Side.CLIENT)
            public static void drawBoundingBox(BufferBuilder buffer, Stream<Line> lines, float red, float green, float blue, float alpha) {
                lines.forEach(ln -> {
                    buffer.func_181662_b(ln.a.field_72450_a, ln.a.field_72448_b, ln.a.field_72449_c).func_181666_a(red, green, blue, 0.0f).func_181675_d();
                    buffer.func_181662_b(ln.a.field_72450_a, ln.a.field_72448_b, ln.a.field_72449_c).func_181666_a(red, green, blue, alpha).func_181675_d();
                    buffer.func_181662_b(ln.b.field_72450_a, ln.b.field_72448_b, ln.b.field_72449_c).func_181666_a(red, green, blue, alpha).func_181675_d();
                });
            }
        }
    }

    public static interface ILinable {
        public List<Line> asLines();
    }
}

