/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.bookAPI.fancy;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.bookAPI.fancy.ManualCategory;
import com.zeitheron.hammercore.bookAPI.fancy.ManualEntry;
import java.util.Collection;
import java.util.LinkedHashMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ManualCategories {
    public static LinkedHashMap<String, ManualCategory> manualCategories = new LinkedHashMap();

    public static ManualCategory getCategory(String key) {
        return manualCategories.get(key);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getCategoryName(String key) {
        return I18n.func_135052_a((String)("hc.manual_cat." + key), (Object[])new Object[0]);
    }

    public static ManualEntry getEntry(String key) {
        Collection<ManualCategory> rc = manualCategories.values();
        for (ManualCategory cat : rc) {
            Collection<ManualEntry> rl = cat.entries.values();
            for (ManualEntry ri : rl) {
                if (!ri.key.equals(key)) continue;
                return ri;
            }
        }
        return null;
    }

    public static void registerCategory(String key, ResourceLocation icon, ResourceLocation background) {
        if (ManualCategories.getCategory(key) == null) {
            ManualCategory rl = new ManualCategory(icon, background);
            manualCategories.put(key, rl);
        }
    }

    public static void registerCategory(String key, ResourceLocation icon) {
        if (ManualCategories.getCategory(key) == null) {
            ManualCategory rl = new ManualCategory(icon);
            manualCategories.put(key, rl);
        }
    }

    public static void registerCategory(String key, ManualCategory rl) {
        if (ManualCategories.getCategory(key) == null) {
            manualCategories.put(key, rl);
        }
    }

    public static void addEntry(ManualEntry ri) {
        ManualCategory rl = ManualCategories.getCategory(ri.category);
        if (rl != null && !rl.entries.containsKey(ri.key)) {
            for (ManualEntry rr : rl.entries.values()) {
                if (rr.displayColumn != ri.displayColumn || rr.displayRow != ri.displayRow) continue;
                HammerCore.LOG.error("Manual Entry [" + ri.getName() + "] not added as it overlaps with existing one [" + rr.getName() + "]");
                return;
            }
            rl.entries.put(ri.key, ri);
            if (ri.displayColumn < rl.minDisplayColumn) {
                rl.minDisplayColumn = ri.displayColumn;
            }
            if (ri.displayRow < rl.minDisplayRow) {
                rl.minDisplayRow = ri.displayRow;
            }
            if (ri.displayColumn > rl.maxDisplayColumn) {
                rl.maxDisplayColumn = ri.displayColumn;
            }
            if (ri.displayRow > rl.maxDisplayRow) {
                rl.maxDisplayRow = ri.displayRow;
            }
        }
    }
}

