/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookParsingException;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.SectionRef;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.conditions.ConditionManager;
import gigaherz.guidebook.guidebook.drawing.VisualChapter;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualPage;
import gigaherz.guidebook.guidebook.drawing.VisualPageBreak;
import gigaherz.guidebook.guidebook.elements.Element;
import gigaherz.guidebook.guidebook.elements.ElementBreak;
import gigaherz.guidebook.guidebook.elements.ElementFactory;
import gigaherz.guidebook.guidebook.elements.ElementImage;
import gigaherz.guidebook.guidebook.elements.ElementInline;
import gigaherz.guidebook.guidebook.elements.ElementLink;
import gigaherz.guidebook.guidebook.elements.ElementPanel;
import gigaherz.guidebook.guidebook.elements.ElementParagraph;
import gigaherz.guidebook.guidebook.elements.ElementRecipe;
import gigaherz.guidebook.guidebook.elements.ElementSpan;
import gigaherz.guidebook.guidebook.elements.ElementStack;
import gigaherz.guidebook.guidebook.elements.ElementText;
import gigaherz.guidebook.guidebook.elements.TextStyle;
import gigaherz.guidebook.guidebook.templates.TemplateDefinition;
import gigaherz.guidebook.guidebook.templates.TemplateElement;
import gigaherz.guidebook.guidebook.templates.TemplateLibrary;
import gigaherz.guidebook.guidebook.util.Point;
import gigaherz.guidebook.guidebook.util.Rect;
import gigaherz.guidebook.guidebook.util.Size;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookDocument
implements IConditionSource {
    private static final float DEFAULT_FONT_SIZE = 1.0f;
    private float fontSize = 1.0f;
    public SectionRef home = new SectionRef(0, 0);
    private final ResourceLocation bookLocation;
    private String bookName;
    private ResourceLocation bookCover;
    private ModelResourceLocation bookModel;
    final List<ChapterData> chapters = Lists.newArrayList();
    private Table<Item, Integer, SectionRef> stackLinks = HashBasedTable.create();
    final Map<String, Integer> chaptersByName = Maps.newHashMap();
    final Map<String, SectionRef> sectionsByName = Maps.newHashMap();
    private final Map<String, TemplateDefinition> templates = Maps.newHashMap();
    private final Map<String, Predicate<ConditionContext>> conditions = Maps.newHashMap();
    private IBookGraphics renderingManager;
    private static final Map<ResourceLocation, ElementFactory> customElements = Maps.newHashMap();
    private ResourceLocation background;

    public static void registerCustomElement(ResourceLocation location, ElementFactory factory) {
        if (customElements.containsKey(location)) {
            throw new RuntimeException("Can not register two custom element factories with the same id.");
        }
        customElements.put(location, factory);
    }

    public BookDocument(ResourceLocation bookLocation) {
        this.bookLocation = bookLocation;
    }

    public ResourceLocation getLocation() {
        return this.bookLocation;
    }

    @Nullable
    public String getName() {
        return this.bookName;
    }

    @Nullable
    public ResourceLocation getCover() {
        return this.bookCover;
    }

    @Nullable
    public ModelResourceLocation getModel() {
        return this.bookModel;
    }

    @Nullable
    public ResourceLocation getBackground() {
        return this.background;
    }

    @Nullable
    public IBookGraphics getRendering() {
        return this.renderingManager;
    }

    public void setRendering(IBookGraphics rendering) {
        this.renderingManager = rendering;
    }

    public ChapterData getChapter(int i) {
        return this.chapters.get(i);
    }

    @Nullable
    public SectionRef getStackLink(ItemStack stack) {
        int damage;
        Item item = stack.func_77973_b();
        if (this.stackLinks.contains((Object)item, (Object)(damage = stack.func_77952_i()))) {
            return (SectionRef)this.stackLinks.get((Object)item, (Object)damage);
        }
        if (this.stackLinks.contains((Object)item, (Object)-1)) {
            return (SectionRef)this.stackLinks.get((Object)item, (Object)-1);
        }
        return null;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int chapterCount() {
        return this.chapters.size();
    }

    public void findTextures(Set<ResourceLocation> textures) {
        if (this.bookCover != null) {
            textures.add(this.bookCover);
        }
        for (ChapterData chapter : this.chapters) {
            for (PageData page : chapter.sections) {
                for (Element element : page.elements) {
                    element.findTextures(textures);
                }
            }
        }
    }

    public void initializeWithLoadError(String error) {
        ChapterData ch = new ChapterData(0);
        this.chapters.add(ch);
        PageData pg = new PageData(new SectionRef(0, 0));
        ch.sections.add(pg);
        pg.elements.add(ElementParagraph.of("Error loading book:", TextStyle.ERROR));
        pg.elements.add(ElementParagraph.of(error, TextStyle.ERROR));
    }

    public boolean parseBook(InputStream stream, boolean loadedFromConfigFolder) {
        try {
            this.chapters.clear();
            this.bookName = "";
            this.bookCover = null;
            this.fontSize = 1.0f;
            this.chaptersByName.clear();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            Node root = doc.getChildNodes().item(0);
            if (root.hasAttributes()) {
                NamedNodeMap attributes = root.getAttributes();
                Node n = attributes.getNamedItem("title");
                if (n != null) {
                    this.bookName = n.getTextContent();
                }
                if ((n = attributes.getNamedItem("cover")) != null) {
                    this.bookCover = new ResourceLocation(n.getTextContent());
                }
                if ((n = attributes.getNamedItem("model")) != null) {
                    this.bookModel = new ModelResourceLocation(n.getTextContent());
                }
                if ((n = attributes.getNamedItem("background")) != null) {
                    this.background = new ResourceLocation(n.getTextContent());
                }
                if ((n = attributes.getNamedItem("fontSize")) != null) {
                    Float f = Floats.tryParse((String)n.getTextContent());
                    float f2 = this.fontSize = f != null ? f.floatValue() : 1.0f;
                }
                if ((n = attributes.getNamedItem("home")) != null) {
                    String[] ref = n.getTextContent();
                    this.home = SectionRef.fromString((String)ref);
                }
                if ((n = attributes.getNamedItem("dependencies")) != null) {
                    for (String s : n.getTextContent().split(",")) {
                        if (Loader.isModLoaded((String)s)) continue;
                        this.initializeWithLoadError("Dependency not loaded: " + s);
                        return false;
                    }
                }
            }
            int chapterNumber = 0;
            NodeList firstLevel = root.getChildNodes();
            for (int i = 0; i < firstLevel.getLength(); ++i) {
                Node firstLevelNode = firstLevel.item(i);
                String nodeName = firstLevelNode.getNodeName();
                if (nodeName.equals("template")) {
                    this.parseTemplateDefinition(firstLevelNode, this.templates);
                    continue;
                }
                if (nodeName.equals("include")) {
                    NamedNodeMap attributes = firstLevelNode.getAttributes();
                    Node n = attributes.getNamedItem("ref");
                    TemplateLibrary tpl = TemplateLibrary.get(n.getTextContent(), loadedFromConfigFolder);
                    this.templates.putAll(tpl.templates);
                    continue;
                }
                if (nodeName.equals("chapter")) {
                    this.parseChapter(chapterNumber++, firstLevelNode);
                    continue;
                }
                if (nodeName.equals("stack-links")) {
                    this.parseStackLinks(firstLevelNode);
                    continue;
                }
                if (!nodeName.equals("conditions")) continue;
                this.parseConditions(firstLevelNode);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.initializeWithLoadError(e.toString());
        }
        return true;
    }

    private void parseConditions(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String name;
            NamedNodeMap attributes;
            Node condition = children.item(i);
            if (condition.getNodeType() != 1 || (attributes = condition.getAttributes()) == null) continue;
            Node conditionName = attributes.getNamedItem("name");
            String string = name = conditionName != null ? conditionName.getTextContent() : null;
            if (Strings.isNullOrEmpty((String)name)) {
                throw new BookParsingException("Condition node found without a name attribute");
            }
            Predicate<ConditionContext> displayCondition = BookDocument.parseSingleCondition(this, condition);
            this.conditions.put(name, displayCondition);
        }
    }

    public static List<Predicate<ConditionContext>> parseChildConditions(BookDocument context, Node node) {
        ArrayList conditions = Lists.newArrayList();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node condition = children.item(i);
            if (condition.getNodeType() != 1) continue;
            Predicate<ConditionContext> displayCondition = BookDocument.parseSingleCondition(context, condition);
            conditions.add(displayCondition);
        }
        return conditions;
    }

    private static Predicate<ConditionContext> parseSingleCondition(BookDocument context, Node condition) {
        Predicate<ConditionContext> displayCondition;
        try {
            displayCondition = ConditionManager.parseCondition(context, condition);
            if (displayCondition == null) {
                throw new BookParsingException("Condition not found");
            }
        }
        catch (Exception e) {
            throw new BookParsingException("Exception parsing condition", e);
        }
        return displayCondition;
    }

    private void parseTemplateDefinition(Node templateItem, Map<String, TemplateDefinition> templates) {
        if (!templateItem.hasAttributes()) {
            return;
        }
        TemplateDefinition page = new TemplateDefinition();
        NamedNodeMap attributes = templateItem.getAttributes();
        Node n = attributes.getNamedItem("id");
        if (n == null) {
            return;
        }
        templates.put(n.getTextContent(), page);
        BookDocument.parseChildElements(this, templateItem, page.elements, templates, true, TextStyle.DEFAULT);
        attributes.removeNamedItem("id");
        page.attributes = attributes;
    }

    private void parseChapter(int chapterNumber, Node chapterItem) {
        ChapterData chapter = new ChapterData(this.chapters.size());
        this.chapters.add(chapter);
        if (chapterItem.hasAttributes()) {
            NamedNodeMap attributes = chapterItem.getAttributes();
            Node n = attributes.getNamedItem("id");
            if (n != null) {
                chapter.id = n.getTextContent();
                this.chaptersByName.put(chapter.id, chapter.num);
            }
            if ((n = attributes.getNamedItem("condition")) != null) {
                chapter.condition = this.conditions.get(n.getTextContent());
            }
        }
        int sectionNumber = 0;
        NodeList pagesList = chapterItem.getChildNodes();
        for (int j = 0; j < pagesList.getLength(); ++j) {
            Node pageItem = pagesList.item(j);
            String nodeName = pageItem.getNodeName();
            if (nodeName.equals("page")) {
                this.parsePage(chapter, new SectionRef(chapterNumber, sectionNumber++), pageItem);
                continue;
            }
            if (!nodeName.equals("section")) continue;
            this.parseSection(chapter, new SectionRef(chapterNumber, sectionNumber++), pageItem);
        }
    }

    private void parsePage(ChapterData chapter, SectionRef ref, Node pageItem) {
        PageData page = new PageData(ref);
        this.parseSection(chapter, pageItem, page);
    }

    private void parseSection(ChapterData chapter, SectionRef ref, Node pageItem) {
        PageGroup page = new PageGroup(ref);
        this.parseSection(chapter, pageItem, page);
    }

    private void parseSection(ChapterData chapter, Node pageItem, PageData page) {
        int num = chapter.sections.size();
        chapter.sections.add(page);
        if (pageItem.hasAttributes()) {
            NamedNodeMap attributes = pageItem.getAttributes();
            Node n = attributes.getNamedItem("id");
            if (n != null) {
                page.id = n.getTextContent();
                this.sectionsByName.put(page.id, new SectionRef(chapter.num, num));
                chapter.sectionsByName.put(page.id, num);
            }
            if ((n = attributes.getNamedItem("condition")) != null) {
                page.condition = this.conditions.get(n.getTextContent());
            }
        }
        BookDocument.parseChildElements(this, pageItem, page.elements, this.templates, true, TextStyle.DEFAULT);
    }

    public static void parseChildElements(IConditionSource book, Node pageItem, List<Element> elements, Map<String, TemplateDefinition> templates, boolean generateParagraphs, TextStyle defaultStyle) {
        NodeList elementsList = pageItem.getChildNodes();
        for (int k = 0; k < elementsList.getLength(); ++k) {
            Element t;
            ElementParagraph p;
            boolean isFirstElement = k == 0;
            boolean isLastElement = k + 1 == elementsList.getLength();
            Node elementItem = elementsList.item(k);
            Element parsedElement = null;
            String nodeName = elementItem.getNodeName();
            ResourceLocation nodeLoc = new ResourceLocation(nodeName);
            if (nodeName.equals("section-break")) {
                parsedElement = new ElementBreak();
            } else if (nodeName.equals("p") || nodeName.equals("title")) {
                p = new ElementParagraph();
                TextStyle tagDefaults = defaultStyle;
                if (nodeName.equals("title")) {
                    p.alignment = 1;
                    p.space = 4;
                    tagDefaults = new TextStyle(defaultStyle.color, true, false, true, 1.0f);
                }
                TextStyle paragraphDefautls = TextStyle.parse(elementItem.getAttributes(), tagDefaults);
                NodeList childList = elementItem.getChildNodes();
                int l = childList.getLength();
                for (int q = 0; q < l; ++q) {
                    Node childNode = childList.item(q);
                    ElementInline parsedChild = BookDocument.parseParagraphElement(book, childNode, childNode.getNodeName(), isFirstElement, isLastElement, paragraphDefautls);
                    if (parsedChild == null) {
                        GuidebookMod.logger.warn("Unrecognized tag: {}", (Object)childNode.getNodeName());
                        continue;
                    }
                    p.inlines.add(parsedChild);
                }
                if (elementItem.hasAttributes()) {
                    p.parse(book, elementItem.getAttributes());
                }
                parsedElement = p;
            } else if (nodeName.equals("space") || nodeName.equals("group") || nodeName.equals("panel") || nodeName.equals("div")) {
                ElementPanel s = new ElementPanel();
                if (elementItem.hasAttributes()) {
                    s.parse(book, elementItem.getAttributes());
                }
                if (elementItem.hasChildNodes()) {
                    ArrayList elementList = Lists.newArrayList();
                    BookDocument.parseChildElements(book, elementItem, elementList, templates, true, defaultStyle);
                    s.innerElements.addAll(elementList);
                }
                parsedElement = s;
            } else if (customElements.containsKey(nodeLoc)) {
                ElementFactory factory = customElements.get(nodeLoc);
                t = factory.newInstance();
                if (elementItem.hasAttributes()) {
                    t.parse(book, elementItem.getAttributes());
                }
                if (elementItem.hasChildNodes()) {
                    t.parseChildNodes(book, elementItem);
                }
                parsedElement = t;
            } else if (templates.containsKey(nodeName)) {
                TemplateDefinition tDef = templates.get(nodeName);
                t = new ElementPanel();
                ((ElementPanel)t).parse(book, tDef.attributes);
                if (elementItem.hasAttributes()) {
                    ((ElementPanel)t).parse(book, elementItem.getAttributes());
                }
                ArrayList elementList = Lists.newArrayList();
                BookDocument.parseChildElements(book, elementItem, elementList, templates, false, defaultStyle);
                List<Element> effectiveList = tDef.applyTemplate(book, elementList);
                ((ElementPanel)t).innerElements.addAll(effectiveList);
                parsedElement = t;
            } else if (elementItem.getNodeType() == 3) {
                String textContent;
                if (generateParagraphs && !Strings.isNullOrEmpty((String)(textContent = ElementText.compactString(elementItem.getTextContent(), isFirstElement, isLastElement))) && !textContent.matches("^[ \t\r\n]+$")) {
                    parsedElement = ElementSpan.of(textContent, defaultStyle);
                }
            } else if (elementItem.getNodeType() != 8 && (parsedElement = BookDocument.parseParagraphElement(book, elementItem, nodeName, isFirstElement, isLastElement, defaultStyle)) == null) {
                GuidebookMod.logger.warn("Unrecognized tag: {}", (Object)nodeName);
            }
            if (parsedElement == null) continue;
            if (!((Element)parsedElement).supportsPageLevel() && generateParagraphs && parsedElement instanceof ElementInline) {
                p = new ElementParagraph();
                if (elementItem.hasAttributes()) {
                    p.parse(book, elementItem.getAttributes());
                    parsedElement.parse(book, elementItem.getAttributes());
                }
                p.inlines.add((ElementInline)parsedElement);
                parsedElement = p;
            }
            if (!((Element)parsedElement).supportsPageLevel()) continue;
            elements.add(parsedElement);
        }
    }

    @Nullable
    public static ElementInline parseParagraphElement(IConditionSource book, Node elementItem, String nodeName, boolean isFirstElement, boolean isLastElement, TextStyle defaultStyle) {
        String textContent;
        ElementInline parsedElement = null;
        if (nodeName.equals("span")) {
            ElementSpan span = new ElementSpan(isFirstElement, isLastElement, new ElementInline[0]);
            if (elementItem.hasAttributes()) {
                span.parse(book, elementItem.getAttributes());
            }
            if (elementItem.hasChildNodes()) {
                TextStyle spanDefaults = TextStyle.parse(elementItem.getAttributes(), defaultStyle);
                ArrayList elementList = Lists.newArrayList();
                BookDocument.parseRunElements(book, elementItem, elementList, spanDefaults);
                span.inlines.addAll(elementList);
            }
            parsedElement = span;
        } else if (nodeName.equals("link")) {
            ElementLink link = new ElementLink(isFirstElement, isLastElement, new ElementInline[0]);
            if (elementItem.hasAttributes()) {
                link.parse(book, elementItem.getAttributes());
            }
            if (elementItem.hasChildNodes()) {
                TextStyle spanDefaults = TextStyle.parse(elementItem.getAttributes(), TextStyle.LINK);
                ArrayList elementList = Lists.newArrayList();
                BookDocument.parseRunElements(book, elementItem, elementList, spanDefaults);
                link.inlines.addAll(elementList);
            }
            parsedElement = link;
        } else if (nodeName.equals("stack")) {
            ElementStack s = new ElementStack(isFirstElement, isLastElement);
            if (elementItem.hasAttributes()) {
                s.parse(book, elementItem.getAttributes());
            }
            parsedElement = s;
        } else if (nodeName.equals("image")) {
            ElementImage i = new ElementImage(isFirstElement, isLastElement);
            if (elementItem.hasAttributes()) {
                i.parse(book, elementItem.getAttributes());
            }
            parsedElement = i;
        } else if (nodeName.equals("element")) {
            TemplateElement i = new TemplateElement(isFirstElement, isLastElement);
            if (elementItem.hasAttributes()) {
                i.parse(book, elementItem.getAttributes());
            }
            parsedElement = i;
        } else if (elementItem.getNodeType() == 3 && !Strings.isNullOrEmpty((String)(textContent = ElementText.compactString(elementItem.getTextContent(), isFirstElement, isLastElement)))) {
            parsedElement = ElementSpan.of(textContent, isFirstElement, isLastElement, defaultStyle);
        }
        return parsedElement;
    }

    public static void parseRunElements(IConditionSource book, Node pageItem, List<ElementInline> elements, TextStyle defaultStyle) {
        NodeList elementsList = pageItem.getChildNodes();
        for (int k = 0; k < elementsList.getLength(); ++k) {
            boolean isFirstElement = k == 0;
            boolean isLastElement = k + 1 == elementsList.getLength();
            Node elementItem = elementsList.item(k);
            ElementInline parsedElement = null;
            String nodeName = elementItem.getNodeName();
            ResourceLocation nodeLoc = new ResourceLocation(nodeName);
            if (customElements.containsKey(nodeLoc)) {
                ElementFactory factory = customElements.get(nodeLoc);
                Element t = factory.newInstance();
                if (t instanceof ElementInline) {
                    if (elementItem.hasAttributes()) {
                        t.parse(book, elementItem.getAttributes());
                    }
                    if (elementItem.hasChildNodes()) {
                        t.parseChildNodes(book, elementItem);
                    }
                    parsedElement = (ElementInline)t;
                }
            } else if (elementItem.getNodeType() == 3) {
                String textContent = ElementText.compactString(elementItem.getTextContent(), isFirstElement, isLastElement);
                if (!Strings.isNullOrEmpty((String)textContent)) {
                    parsedElement = ElementSpan.of(textContent, isFirstElement, isLastElement, defaultStyle);
                }
            } else if (elementItem.getNodeType() != 8 && (parsedElement = BookDocument.parseParagraphElement(book, elementItem, nodeName, isFirstElement, isLastElement, defaultStyle)) == null) {
                GuidebookMod.logger.warn("Unrecognized tag: {}", (Object)nodeName);
            }
            if (parsedElement == null) continue;
            elements.add(parsedElement);
        }
    }

    private void parseStackLinks(Node refsItem) {
        NodeList refsList = refsItem.getChildNodes();
        for (int j = 0; j < refsList.getLength(); ++j) {
            Item item;
            Node item_node;
            Node refItem = refsList.item(j);
            String nodeName = refItem.getNodeName();
            if (!nodeName.equals("stack") || !refItem.hasAttributes() || (item_node = refItem.getAttributes().getNamedItem("item")) == null || (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(item_node.getTextContent()))) == null) continue;
            int damage_value = 0;
            Node meta = refItem.getAttributes().getNamedItem("meta");
            if (meta != null) {
                damage_value = meta.getTextContent().equals("*") ? -1 : Ints.tryParse((String)meta.getTextContent());
            }
            String ref = refItem.getTextContent();
            this.stackLinks.put((Object)item, (Object)damage_value, (Object)SectionRef.fromString(ref));
        }
    }

    @Override
    public Predicate<ConditionContext> getCondition(String name) {
        return this.conditions.get(name);
    }

    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean anyChanged = false;
        for (ChapterData chapter : this.chapters) {
            anyChanged |= chapter.reevaluateConditions(ctx);
        }
        return anyChanged;
    }

    static {
        BookDocument.registerCustomElement(new ResourceLocation("minecraft:recipe"), ElementRecipe::new);
    }

    public class PageGroup
    extends PageData {
        public PageGroup(SectionRef ref) {
            super(ref);
        }

        @Override
        public List<VisualPage> reflow(IBookGraphics rendering, Size pageSize) {
            ArrayList pages = Lists.newArrayList();
            VisualPage page = new VisualPage(this.ref);
            Rect pageBounds = new Rect(new Point(0, 0), pageSize);
            int top = pageBounds.position.y;
            for (Object element : this.elements) {
                if (!((Element)element).conditionResult) continue;
                top = ((Element)element).reflow(page.children, rendering, new Rect(new Point(pageBounds.position.x, top), pageBounds.size), pageBounds);
            }
            boolean needsRepagination = false;
            for (VisualElement child : page.children) {
                if (!(child instanceof VisualPageBreak) && child.position.y + child.size.height <= pageBounds.position.y + pageBounds.size.height) continue;
                needsRepagination = true;
                break;
            }
            if (needsRepagination) {
                VisualPage page2 = new VisualPage(this.ref);
                int offsetY = 0;
                boolean pageBreakRequired = false;
                for (VisualElement child : page.children) {
                    int cpy = child.position.y + offsetY;
                    if (pageBreakRequired || cpy + child.size.height > pageBounds.position.y + pageBounds.size.height && child.position.y > pageBounds.position.y) {
                        pages.add(page2);
                        page2 = new VisualPage(this.ref);
                        offsetY = pageBounds.position.y - child.position.y;
                        pageBreakRequired = false;
                    }
                    if (child instanceof VisualPageBreak) {
                        pageBreakRequired = true;
                        continue;
                    }
                    child.position = new Point(child.position.x, child.position.y + offsetY);
                    page2.children.add(child);
                }
                pages.add(page2);
            } else {
                pages.add(page);
            }
            return pages;
        }
    }

    public class PageData {
        public final SectionRef ref;
        public String id;
        public Predicate<ConditionContext> condition;
        public boolean conditionResult;
        public final List<Element> elements = Lists.newArrayList();

        public PageData(SectionRef ref) {
            this.ref = ref;
        }

        public List<VisualPage> reflow(IBookGraphics rendering, Size pageSize) {
            VisualPage page = new VisualPage(this.ref);
            Rect pageBounds = new Rect(new Point(), pageSize);
            int top = 0;
            for (Element element : this.elements) {
                if (!element.conditionResult) continue;
                top = element.reflow(page.children, rendering, new Rect(new Point(0, top), pageSize), pageBounds);
            }
            return Collections.singletonList(page);
        }

        public boolean reevaluateConditions(ConditionContext ctx) {
            boolean oldValue = this.conditionResult;
            this.conditionResult = this.condition == null || this.condition.test(ctx);
            boolean anyChanged = this.conditionResult != oldValue;
            for (Element element : this.elements) {
                anyChanged |= element.reevaluateConditions(ctx);
            }
            return anyChanged;
        }

        public boolean isEmpty() {
            return this.elements.stream().noneMatch(e -> e.conditionResult);
        }
    }

    public class ChapterData {
        public final int num;
        public String id;
        public Predicate<ConditionContext> condition;
        public boolean conditionResult;
        public final List<PageData> sections = Lists.newArrayList();
        public final Map<String, Integer> sectionsByName = Maps.newHashMap();

        private ChapterData(int num) {
            this.num = num;
        }

        public boolean reevaluateConditions(ConditionContext ctx) {
            boolean oldValue = this.conditionResult;
            this.conditionResult = this.condition == null || this.condition.test(ctx);
            boolean anyChanged = this.conditionResult != oldValue;
            for (PageData section : this.sections) {
                anyChanged |= section.reevaluateConditions(ctx);
            }
            return anyChanged;
        }

        public void reflow(IBookGraphics rendering, VisualChapter ch, Size pageSize) {
            for (PageData section : this.sections) {
                if (!section.conditionResult || section.isEmpty()) continue;
                if (!Strings.isNullOrEmpty((String)section.id)) {
                    ch.pagesByName.put(section.id, ch.pages.size());
                }
                ch.pages.addAll(section.reflow(rendering, pageSize));
            }
        }

        public boolean isEmpty() {
            return this.sections.stream().noneMatch(s -> s.conditionResult && !s.isEmpty());
        }
    }
}

