/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;

public class RenderOverlayEventHook {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 51;
    protected static final ResourceLocation BLOOD_OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private int filledHeight = -1;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (GeneralConfig.bloodGuiOverlay && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (this.filledHeight < 0 || WorldHelpers.efficientTick((World)player.field_70170_p, (int)50, (int[])new int[0])) {
                Wrapper<Integer> amount = new Wrapper<Integer>(0);
                Wrapper<Integer> capacity = new Wrapper<Integer>(1);
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator((EntityPlayer)player);
                while (it.hasNext()) {
                    ItemStack itemStack = it.next();
                    IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
                    if (itemStack.func_190926_b() || fluidHandler == null) continue;
                    FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                    if (fluidStack != null && BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) {
                        amount.set(amount.get() + fluidStack.amount);
                    }
                    if (fluidStack != null && !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                    capacity.set(capacity.get() + FluidHelpers.getCapacity((IFluidHandler)fluidHandler));
                }
                this.filledHeight = (int)Math.floor(51.0f * ((float)amount.get().intValue() / (float)capacity.get().intValue()));
            }
            if (this.filledHeight > 0) {
                OverlayPosition overlayPosition = OverlayPosition.values()[MathHelper.func_76125_a((int)GeneralConfig.bloodGuiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
                ScaledResolution resolution = event.getResolution();
                int x = overlayPosition.getX(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetX;
                int y = overlayPosition.getY(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetY;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                RenderHelpers.bindTexture((ResourceLocation)BLOOD_OVERLAY);
                Minecraft.func_71410_x().field_71456_v.func_73729_b(x, y, 0, 0, 5, 51);
                Minecraft.func_71410_x().field_71456_v.func_73729_b(x, y + (51 - this.filledHeight), 5, 51 - this.filledHeight, 5, this.filledHeight);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static enum OverlayPosition {
        NE{

            @Override
            public int getX(ScaledResolution resolution, int width, int height) {
                return resolution.func_78326_a() - width;
            }

            @Override
            public int getY(ScaledResolution resolution, int width, int height) {
                return 0;
            }
        }
        ,
        SE{

            @Override
            public int getX(ScaledResolution resolution, int width, int height) {
                return resolution.func_78326_a() - width;
            }

            @Override
            public int getY(ScaledResolution resolution, int width, int height) {
                return resolution.func_78328_b() - height;
            }
        }
        ,
        SW{

            @Override
            public int getX(ScaledResolution resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(ScaledResolution resolution, int width, int height) {
                return resolution.func_78328_b() - height;
            }
        }
        ,
        NW{

            @Override
            public int getX(ScaledResolution resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(ScaledResolution resolution, int width, int height) {
                return 0;
            }
        };


        public abstract int getX(ScaledResolution var1, int var2, int var3);

        public abstract int getY(ScaledResolution var1, int var2, int var3);
    }
}

