/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.item.Broom;

public class BroomPartCombinationRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final int recipeSize;

    public BroomPartCombinationRecipe(int recipeSize) {
        this.recipeSize = recipeSize;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return !this.func_77572_b(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)Broom.getInstance());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inventory);
        if (result != null) {
            List extraOutputs = (List)result.getRight();
            for (ItemStack extraOutput : extraOutputs) {
                InventoryHelpers.tryReAddToStack((EntityPlayer)ForgeHooks.getCraftingPlayer(), (ItemStack)ItemStack.field_190927_a, (ItemStack)extraOutput, (EnumHand)ForgeHooks.getCraftingPlayer().func_184600_cs());
            }
        }
        return aitemstack;
    }

    protected Map<IBroomPart.BroomPartType, IBroomPart> indexifyParts(Collection<IBroomPart> parts) {
        HashMap map = Maps.newHashMap();
        for (IBroomPart part : parts) {
            if (part.getType() == IBroomPart.BroomPartType.MODIFIER) continue;
            map.put(part.getType(), part);
        }
        return map;
    }

    protected Pair<ItemStack, List<ItemStack>> getResult(InventoryCrafting grid) {
        ItemStack element;
        int j;
        ItemStack output = this.func_77571_b().func_77946_l();
        LinkedList extraOutputs = Lists.newLinkedList();
        int existingBroomSlot = -1;
        Map<IBroomPart.BroomPartType, IBroomPart> existingBroomParts = null;
        HashMap parts = Maps.newHashMap();
        LinkedList rawModifiers = Lists.newLinkedList();
        for (j = 0; j < grid.func_70302_i_(); ++j) {
            Map<IBroomPart.BroomPartType, IBroomPart> currentExistingBroomParts;
            element = grid.func_70301_a(j);
            if (element.func_190926_b() || !(element.func_77973_b() instanceof IBroom) || (currentExistingBroomParts = this.indexifyParts(BroomParts.REGISTRY.getBroomParts(element))) == null || !this.areValidBroomParts(currentExistingBroomParts.values()) || element.func_190916_E() != 1) continue;
            if (existingBroomParts == null) {
                existingBroomParts = currentExistingBroomParts;
                output = element.func_77946_l();
                existingBroomSlot = j;
                continue;
            }
            return null;
        }
        for (j = 0; j < grid.func_70302_i_(); ++j) {
            element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            Object part = BroomParts.REGISTRY.getPartFromItem(element);
            Map<BroomModifier, Float> modifier = BroomModifiers.REGISTRY.getModifiersFromItem(element);
            if (part != null) {
                if (parts.containsKey(part.getType())) {
                    return null;
                }
                parts.put(part.getType(), part);
                continue;
            }
            if (modifier != null) {
                rawModifiers.add(modifier);
                continue;
            }
            if (j == existingBroomSlot) continue;
            return null;
        }
        if (existingBroomParts != null) {
            for (Map.Entry entry : existingBroomParts.entrySet()) {
                if (parts.containsKey(entry.getKey())) {
                    extraOutputs.add(((ItemStack)Iterables.get(BroomParts.REGISTRY.getItemsFromPart((IBroomPart)entry.getValue()), (int)0)).func_77946_l());
                    continue;
                }
                parts.put(entry.getKey(), entry.getValue());
            }
        }
        if (!this.areValidBroomParts(parts.values())) {
            return null;
        }
        BroomParts.REGISTRY.setBroomParts(output, parts.values());
        Map<BroomModifier, Float> broomModifiers = BroomModifiers.REGISTRY.getModifiers(output);
        Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(output);
        this.applyNewModifiers(broomModifiers, rawModifiers);
        if (!this.areValidBroomModifiers(broomModifiers, baseModifiers)) {
            return null;
        }
        BroomModifiers.REGISTRY.setModifiers(output, broomModifiers);
        return Pair.of((Object)output, (Object)extraOutputs);
    }

    private void applyNewModifiers(Map<BroomModifier, Float> baseModifiers, List<Map<BroomModifier, Float>> rawModifiers) {
        for (Map<BroomModifier, Float> modifierValue : rawModifiers) {
            for (Map.Entry<BroomModifier, Float> entry : modifierValue.entrySet()) {
                BroomModifier modifier = entry.getKey();
                Float value = baseModifiers.get(entry.getKey());
                if (value != null) {
                    baseModifiers.put(modifier, Float.valueOf(modifier.apply(value.floatValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
                    continue;
                }
                baseModifiers.put(modifier, Float.valueOf(modifier.apply(modifier.getDefaultValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
            }
        }
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(grid);
        if (result == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)result.getLeft();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeSize;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)this.recipeSize, (Object)((Object)new BroomPartIngredient()));
    }

    private boolean areValidBroomParts(Collection<IBroomPart> parts) {
        HashSet remainingRequiredTypes = Sets.newHashSet((Object[])IBroomPart.BroomPartType.BASE_TYPES);
        for (IBroomPart part : parts) {
            remainingRequiredTypes.remove(part.getType());
        }
        return remainingRequiredTypes.isEmpty();
    }

    private boolean areValidBroomModifiers(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = (int)Math.ceil(entry.getValue().floatValue() / entry.getKey().getTierValue());
            if (tier > entry.getKey().getMaxTiers()) {
                return false;
            }
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        broomModifiers.put(BroomModifiers.MODIFIER_COUNT, Float.valueOf((float)maxModifiers - (float)baseMaxModifiers));
        return modifiers <= maxModifiers;
    }

    public static class BroomPartIngredient
    extends Ingredient {
        public BroomPartIngredient() {
            super(new ItemStack[0]);
        }

        public ItemStack[] func_193365_a() {
            return (ItemStack[])BroomParts.REGISTRY.getParts().stream().map(BroomParts.REGISTRY::getItemsFromPart).flatMap(Collection::stream).toArray(ItemStack[]::new);
        }

        public boolean apply(ItemStack itemStack) {
            return !itemStack.func_190926_b() && (itemStack.func_77973_b() instanceof IBroom || BroomParts.REGISTRY.getPartFromItem(itemStack) != null);
        }
    }
}

