/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.evilcraft.core.fluid.SimulatedFluidStack;

public class FluidContainerItemWrapperWithSimulation
extends FluidHandlerItemCapacity {
    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity, fluid);
    }

    protected boolean shouldDoFill(FluidStack resource, boolean doFill) {
        if (!doFill) {
            return false;
        }
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        if (stackTraceElement.getClassName().equals("net.minecraftforge.fluids.FluidUtil") && stackTraceElement.getMethodName().equals("tryFillContainer")) {
            doFill = false;
        }
        if (resource instanceof SimulatedFluidStack) {
            doFill = false;
        }
        return doFill;
    }

    public int fill(FluidStack resource, boolean doFill) {
        doFill = this.shouldDoFill(resource, doFill);
        return super.fill(resource, doFill);
    }

    protected FluidStack wrapSimulatedDrained(FluidStack drained, boolean doDrain) {
        if (doDrain || drained == null || drained.amount == 0) {
            return drained;
        }
        return new SimulatedFluidStack(drained.getFluid(), drained.amount);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        return this.wrapSimulatedDrained(drained, doDrain);
    }

    protected boolean shouldDoDrain(FluidStack resource, boolean doDrain) {
        if (!doDrain) {
            return false;
        }
        if (resource instanceof SimulatedFluidStack) {
            doDrain = false;
        }
        return doDrain;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        doDrain = this.shouldDoDrain(resource, doDrain);
        return this.wrapSimulatedDrained(super.drain(resource, doDrain), doDrain);
    }
}

