/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.tileentity.TileSpiritPortal;

public class SpiritPortal
extends ConfigurableBlockContainer {
    private static SpiritPortal _instance = null;

    public static SpiritPortal getInstance() {
        return _instance;
    }

    public SpiritPortal(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileSpiritPortal.class);
        this.setRotatable(true);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.5f);
        this.setRotatable(false);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.4f, (double)0.4f, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState blockState) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    public void func_176208_a(World world, BlockPos blockPos, IBlockState blockStatedata, EntityPlayer player) {
        world.func_175698_g(blockPos);
    }

    protected static boolean canReplaceBlock(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return blockState != null && (blockState.func_177230_c().isAir(blockState, world, pos) || blockState.func_185904_a().func_76222_j());
    }

    public static boolean tryPlacePortal(World world, BlockPos blockPos) {
        RegionIterator it = new RegionIterator(blockPos, 1, true);
        for (int attempts = 9; it.hasNext() && attempts >= 0; --attempts) {
            BlockPos location = it.next();
            if (!SpiritPortal.canReplaceBlock(world.func_180495_p(location), (IBlockAccess)world, blockPos)) continue;
            world.func_180501_a(location, SpiritPortal.getInstance().func_176223_P(), 3);
            return true;
        }
        return false;
    }
}

