/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class EntangledChaliceItem
extends ItemBlockFluidContainer {
    public EntangledChaliceItem(Block block) {
        super(block);
    }

    @Override
    protected void autofill(int itemSlot, IFluidHandlerItem source, World world, Entity entity) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            FluidStack tickFluid;
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                ItemStack filled;
                tickFluid = FluidHelpers.getFluid((IFluidHandler)source);
                ItemStack toFill = it.next();
                if (tickFluid == null || toFill.func_190926_b() || toFill.func_190916_E() != 1 || (filled = ItemHelpers.tryFillContainerForPlayer(source, toFill, tickFluid, player)).func_190926_b()) continue;
                it.replace(filled);
                player.field_71071_by.func_70299_a(itemSlot, source.getContainer());
            } while (tickFluid != null && tickFluid.amount > 0 && it.hasNext());
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack, 4000);
    }

    @Override
    protected void itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        super.itemStackDataToTile(itemStack, tile);
        FluidHandler fluidHandler = (FluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack);
        String tankId = fluidHandler.getTankID();
        ((TileEntangledChalice)tile).setWorldTankId(tankId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        FluidHandler fluidHandler = (FluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack);
        String tankId = fluidHandler == null ? "null" : fluidHandler.getTankID();
        list.add(L10NHelpers.localize((String)"tile.blocks.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{tankId}));
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public FluidStack getFluid() {
            return WorldSharedTankCache.getInstance().getTankContent(this.getTankID());
        }

        protected void setFluid(FluidStack fluidStack) {
            WorldSharedTankCache.getInstance().setTankContent(this.getTankID(), fluidStack);
        }

        protected void setContainerToEmpty() {
            this.setFluid(null);
        }

        public String getTankID() {
            NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.getContainer());
            if (!tag.func_74764_b("tankID")) {
                tag.func_74778_a("tankID", "");
            }
            return tag.func_74779_i("tankID");
        }

        public void setTankID(String tankID) {
            NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.getContainer());
            tag.func_74778_a("tankID", tankID);
        }

        public void setNextTankID() {
            this.setTankID(Integer.toString(EvilCraft.globalCounters.getNext("EntangledChalice")));
        }
    }
}

