/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.BlockContainerConfig;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.client.render.tileentity.RenderTileEntityDarkTank;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class DarkTankConfig
extends BlockContainerConfig {
    public static DarkTankConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum tank size possible by combining tanks. (Make sure that you do not cross the max int size.)")
    public static int maxTankSize;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum tank size visible in the creative tabs. (Make sure that you do not cross the max int size.)")
    public static int maxTankCreativeSize;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If creative versions for all fluids should be added to the creative tab.")
    public static boolean creativeTabFluids;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If the fluid should be rendered statically. Fluids won't be shown fluently, but more efficiently.tab.", requiresMcRestart=true)
    public static boolean staticBlockRendering;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If held buckets should be autofilled when enabled.", isCommandable=true)
    public static boolean autoFillBuckets;

    public DarkTankConfig() {
        super((ModBase)EvilCraft._instance, true, "dark_tank", null, DarkTank.class);
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockFluidContainer.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        if (!staticBlockRendering) {
            this.getMod().getProxy().registerRenderer(TileDarkTank.class, (TileEntitySpecialRenderer)new RenderTileEntityDarkTank());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            for (int meta = 0; meta < 2; ++meta) {
                Item item = Item.func_150898_a((Block)this.getBlockInstance());
                String modId = this.getMod().getModId();
                String itemName = this.getModelName(new ItemStack(item, 1, meta));
                ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modId + ":" + itemName, "inventory");
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, modelResourceLocation);
            }
        }
    }

    public String getModelName(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return super.getModelName(itemStack) + "_off";
        }
        return super.getModelName(itemStack) + "_on";
    }

    static {
        maxTankSize = 65536000;
        maxTankCreativeSize = 4096000;
        creativeTabFluids = true;
        staticBlockRendering = false;
        autoFillBuckets = false;
    }
}

