/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.teleporter;

import erebus.ModBlocks;
import erebus.blocks.BlockGaeanKeystone;
import erebus.core.handler.configs.ConfigHandler;
import erebus.tileentity.TileEntityGaeanKeystone;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

final class TeleporterErebus
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);
    private final List<Long> destinationCoordinateKeys = new ArrayList<Long>();
    public static final String LAST_PORTAL_POS_NBT = "erebus.last_portal_location";

    TeleporterErebus(WorldServer worldServer) {
        super(worldServer);
        this.worldServerInstance = worldServer;
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        if (entity instanceof EntityPlayerMP && !((EntityPlayerMP)entity).field_71075_bZ.field_75098_d) {
            ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)((EntityPlayerMP)entity), (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj"});
        }
        if (!this.func_180620_b(entity, rotationYaw) && this.worldServerInstance.field_73011_w.getDimension() == ConfigHandler.INSTANCE.erebusDimensionID) {
            this.func_85188_a(entity);
            this.func_180620_b(entity, rotationYaw);
        }
        this.moveToEmptyArea(entity);
    }

    private void moveToEmptyArea(Entity entity) {
        while (!this.isClear(entity)) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    private boolean isClear(Entity ent) {
        AxisAlignedBB box = ent.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        if ((double)minX < 0.0) {
            --minX;
        }
        if ((double)minY < 0.0) {
            --minY;
        }
        if ((double)minZ < 0.0) {
            --minZ;
        }
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    IBlockState block = this.worldServerInstance.func_180495_p(new BlockPos(x, y, z));
                    Material mat = block.func_185904_a();
                    if (!mat.func_76224_d() && !mat.func_76220_a() && mat.func_186274_m() != EnumPushReaction.BLOCK) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        int checkRadius = 128;
        double distToPortal = Double.POSITIVE_INFINITY;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        long coordPair = ChunkPos.func_77272_a((int)entityX, (int)entityZ);
        boolean portalNotSaved = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        if (this.destinationCoordinateCache.containsKey(coordPair)) {
            Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)this.destinationCoordinateCache.get(coordPair);
            distToPortal = 0.0;
            blockpos = portalPosition.func_177981_b(1);
            portalPosition.field_85087_d = this.worldServerInstance.func_82737_E();
            portalNotSaved = false;
        } else {
            for (int chunkX = entityX - checkRadius; chunkX <= entityX + checkRadius; chunkX += 16) {
                for (int chunkZ = entityZ - checkRadius; chunkZ <= entityZ + checkRadius; chunkZ += 16) {
                    Chunk chunk = this.worldServerInstance.func_175726_f(new BlockPos(chunkX, entityY, chunkZ));
                    for (TileEntity te : chunk.func_177434_r().values()) {
                        double dz;
                        double dy;
                        double dx;
                        double dSq;
                        if (!(te instanceof TileEntityGaeanKeystone) || (dSq = (dx = entity.field_70165_t - (double)te.func_174877_v().func_177958_n()) * dx + (dy = entity.field_70163_u - (double)te.func_174877_v().func_177956_o()) * dy + (dz = entity.field_70161_v - (double)te.func_174877_v().func_177952_p()) * dz) > distToPortal) continue;
                        distToPortal = dSq;
                        blockpos = te.func_174877_v();
                    }
                }
            }
            distToPortal = Math.sqrt(distToPortal);
        }
        if (distToPortal < (double)checkRadius) {
            if (portalNotSaved) {
                this.destinationCoordinateCache.put(coordPair, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.worldServerInstance.func_82737_E()));
                this.destinationCoordinateKeys.add(coordPair);
            }
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            double newPosX = (double)blockpos.func_177958_n() + 0.5;
            double newPosY = (double)blockpos.func_177956_o() + 1.0;
            double newPosZ = (double)blockpos.func_177952_p() + 0.5;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(newPosX, newPosY, newPosZ, entity.field_70177_z, entity.field_70125_A);
                if (ConfigHandler.INSTANCE.allowRespawning) {
                    this.setDefaultPlayerSpawnLocation(blockpos.func_177981_b(1), entity);
                }
            } else {
                entity.func_70012_b(newPosX, newPosY, newPosZ, entity.field_70177_z, entity.field_70125_A);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        double safeHeight = Math.min(Math.max(entity.field_70163_u, 12.0), 116.0);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)safeHeight) - 2;
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        ((BlockGaeanKeystone)ModBlocks.GAEAN_KEYSTONE).buildDestinationPortal((World)this.worldServerInstance, x, y, z);
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            ObjectIterator objectIterator = this.destinationCoordinateCache.values().iterator();
            while (objectIterator.hasNext()) {
                Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)objectIterator.next();
                if (portalPosition != null && portalPosition.field_85087_d >= worldTime - 300L) continue;
                objectIterator.remove();
            }
        }
    }

    public BlockPos setDefaultPlayerSpawnLocation(BlockPos portalPos, Entity entity) {
        if (!(entity instanceof EntityPlayerMP)) {
            return portalPos;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        BlockPos coords = player.getBedLocation(ConfigHandler.INSTANCE.erebusDimensionID);
        if (coords == null) {
            coords = portalPos;
            player.setSpawnChunk(coords, true, ConfigHandler.INSTANCE.erebusDimensionID);
        }
        if (this.worldServerInstance.field_73011_w.getDimension() == ConfigHandler.INSTANCE.erebusDimensionID) {
            NBTTagCompound dataNbt = player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            persistentNbt.func_74772_a(LAST_PORTAL_POS_NBT, portalPos.func_177986_g());
            dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
        }
        return coords;
    }
}

