/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.decoration;

import erebus.ModBlocks;
import erebus.ModEntities;
import erebus.ModItems;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityPreservedBlock;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAmberGround
extends WorldGenerator {
    private static final float BUGGED_AMBER_CHANCE = 0.01f;
    private static final float WAND_CHANCE = 0.05f;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean plausible = false;
        int y = pos.func_177956_o();
        for (int a = 0; a < 10; ++a) {
            if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()) == Blocks.field_150349_c.func_176223_P()) {
                plausible = true;
                break;
            }
            if (--y > 1) continue;
            return false;
        }
        if (!plausible) {
            return false;
        }
        float rad = rand.nextFloat() + 2.6f;
        int ceilRad = 1 + (int)Math.ceil(rad);
        for (int xx = -ceilRad; xx <= ceilRad; ++xx) {
            for (int yy = -ceilRad; yy <= ceilRad; ++yy) {
                for (int zz = -ceilRad; zz <= ceilRad; ++zz) {
                    if (!(Math.sqrt(xx * xx + yy * yy + zz * zz) <= (double)(rad + rand.nextFloat() * 0.4f))) continue;
                    this.setAmberBlock(world, pos.func_177982_a(xx, yy, zz), rand);
                }
            }
        }
        return true;
    }

    protected void setAmberBlock(World world, BlockPos pos, Random rand) {
        if (rand.nextFloat() > 0.01f) {
            world.func_175656_a(pos, ModBlocks.AMBER.func_176223_P());
        } else {
            world.func_180501_a(pos, ModBlocks.PRESERVED_BLOCK.func_176223_P(), 3);
            TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntityPreservedBlock.class);
            if (tile != null) {
                try {
                    EntityItem entity;
                    if (rand.nextFloat() > 0.05f) {
                        Class<? extends EntityLiving> cls = ModEntities.getRandomEntityClass();
                        entity = (Entity)cls.getConstructor(World.class).newInstance(world);
                    } else {
                        EntityItem item = new EntityItem(world);
                        item.func_92058_a(new ItemStack(ModItems.WAND_OF_PRESERVATION));
                        entity = item;
                    }
                    entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    world.func_72838_d((Entity)entity);
                    NBTTagCompound nbt = new NBTTagCompound();
                    entity.func_189511_e(nbt);
                    nbt.func_74778_a("id", EntityList.func_191301_a((Entity)entity).toString());
                    tile.rotation = (byte)rand.nextInt(4);
                    tile.setEntityNBT(nbt);
                    entity.func_70106_y();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

