/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.ai.EntityAIEatCrops;
import erebus.items.ItemErebusFood;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGrasshopper
extends EntityCreature {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    public boolean isEating;

    public EntityGrasshopper(World world) {
        super(world);
        this.func_70105_a(1.3f, 0.75f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.field_70767_i = new GrasshopperJumpHelper(this);
        this.field_70765_h = new GrasshopperMoveHelper(this);
        this.setMovementSpeed(0.5);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.48));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEatCrops((EntityLiving)this, 0.6, 20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.8));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.GRASSHOPPER_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.GRASSHOPPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit) {
            int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
            for (int amount = 0; amount < chance; ++amount) {
                if (this.func_70027_ad()) {
                    this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1, ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_COOKED.ordinal()), 0.0f);
                    continue;
                }
                this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1, ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_RAW.ordinal()), 0.0f);
            }
        }
    }

    public void setIsEating(boolean isEating) {
        this.isEating = isEating;
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.5f : 0.5f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double moveSpeedSq;
        super.func_70664_aZ();
        double moveSpeed = this.field_70765_h.func_75638_b();
        if (moveSpeed > 0.0 && (moveSpeedSq = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float setJumpCompletion(float partialTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTicks) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
    }

    public void startJumping() {
        if (this.isEating) {
            return;
        }
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            GrasshopperJumpHelper grasshopperjumphelper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(grasshopperjumphelper = (GrasshopperJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!grasshopperjumphelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void func_174830_Y() {
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((GrasshopperJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((GrasshopperJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    static class GrasshopperMoveHelper
    extends EntityMoveHelper {
        private final EntityGrasshopper grasshopper;
        private double nextJumpSpeed;

        public GrasshopperMoveHelper(EntityGrasshopper grasshopper) {
            super((EntityLiving)grasshopper);
            this.grasshopper = grasshopper;
        }

        public void func_75641_c() {
            if (this.grasshopper.field_70122_E && !this.grasshopper.field_70703_bu && !((GrasshopperJumpHelper)this.grasshopper.field_70767_i).getIsJumping()) {
                this.grasshopper.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.grasshopper.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.grasshopper.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class GrasshopperJumpHelper
    extends EntityJumpHelper {
        private final EntityGrasshopper grasshopper;
        private boolean canJump;

        public GrasshopperJumpHelper(EntityGrasshopper grasshopper) {
            super((EntityLiving)grasshopper);
            this.grasshopper = grasshopper;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.grasshopper.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

