/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.helper.Utils;
import erebus.entity.EntityAnimatedBlock;
import erebus.entity.ai.EntityAIBlockFollowOwner;
import erebus.tileentity.TileEntityAnimatedChest;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAnimatedChest
extends EntityAnimatedBlock {
    private static final DataParameter<Float> OPENTICKS = EntityDataManager.func_187226_a(EntityAnimatedChest.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PREV_OPENTICKS = EntityDataManager.func_187226_a(EntityAnimatedChest.class, (DataSerializer)DataSerializers.field_187193_c);
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    boolean isOpen;

    public EntityAnimatedChest(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OPENTICKS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PREV_OPENTICKS, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackNearestTarget);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBlockFollowOwner(this, 1.0, 10.0f, 2.0f));
    }

    public boolean func_190530_aW() {
        return true;
    }

    public EntityAnimatedChest setContents(IInventory chest) {
        if (chest == null) {
            return this;
        }
        this.inventory = NonNullList.func_191197_a((int)chest.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i).func_190926_b()) continue;
            this.inventory.set(i, (Object)chest.func_70301_a(i).func_77946_l());
            chest.func_70299_a(i, ItemStack.field_190927_a);
        }
        return this;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.field_70128_L) {
            for (ItemStack is : this.inventory) {
                if (is.func_190926_b()) continue;
                Utils.dropStack(this.func_130014_f_(), this.func_180425_c(), is);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            this.setPrevOpenTicks(this.getOpenTicks());
            if (this.isOpen && this.getOpenTicks() < 1.0f) {
                this.setOpenTicks(this.getOpenTicks() + 0.1f);
            }
            if (!this.isOpen && this.getOpenTicks() > 0.0f) {
                this.setOpenTicks(this.getOpenTicks() - 0.1f);
            }
            if (this.getOpenTicks() > 1.0f) {
                this.setOpenTicks(1.0f);
            }
            if (this.getOpenTicks() < 0.0f) {
                this.setOpenTicks(0.0f);
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.WAND_OF_ANIMATION) {
            this.func_70106_y();
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), ModSounds.ALTAR_OFFERING, SoundCategory.NEUTRAL, 0.2f, 1.0f);
            this.func_130014_f_().func_180501_a(this.func_180425_c(), this.blockID.func_176203_a(this.blockMeta), 3);
            TileEntityChest chest = Utils.getTileEntity((IBlockAccess)this.func_130014_f_(), this.func_180425_c(), TileEntityChest.class);
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                chest.func_70299_a(i, (ItemStack)this.inventory.get(i));
            }
            return true;
        }
        if (is.func_190926_b()) {
            player.func_71007_a((IInventory)new TileEntityAnimatedChest(this));
            return true;
        }
        return false;
    }

    public void setOpen(boolean open) {
        if (!this.func_130014_f_().field_72995_K) {
            if (open) {
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, 0.9f);
            } else {
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, 0.9f);
            }
        }
        this.isOpen = open;
    }

    public boolean getOpen() {
        return this.isOpen;
    }

    public void setOpenTicks(float ticks) {
        this.field_70180_af.func_187227_b(OPENTICKS, (Object)Float.valueOf(ticks));
    }

    public float getOpenTicks() {
        return ((Float)this.field_70180_af.func_187225_a(OPENTICKS)).floatValue();
    }

    public void setPrevOpenTicks(float ticks) {
        this.field_70180_af.func_187227_b(PREV_OPENTICKS, (Object)Float.valueOf(ticks));
    }

    public float getPrevOpenTicks() {
        return ((Float)this.field_70180_af.func_187225_a(PREV_OPENTICKS)).floatValue();
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.inventory = NonNullList.func_191197_a((int)this.getSizeInventory(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.inventory, (boolean)false);
        return compound;
    }

    public int getSizeInventory() {
        return this.inventory.size();
    }
}

