/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.slicensplice.SliceAndSpliceRecipeManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import shadows.endertweaker.EnderTweaker;
import shadows.endertweaker.RecipeUtils;
import shadows.endertweaker.recipe.ManyToOneRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.SliceNSplice")
@ZenRegister
public class SliceNSplice {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input, @Optional int energyCost, @Optional float xp) {
        if (SliceNSplice.hasErrors(output, input)) {
            return;
        }
        EnderTweaker.ADDITIONS.add(() -> {
            RecipeOutput out = new RecipeOutput(CraftTweakerMC.getItemStack((IItemStack)output), 1.0f, xp);
            ManyToOneRecipe rec = new ManyToOneRecipe(out, energyCost <= 0 ? 5000 : energyCost, RecipeBonusType.NONE, RecipeLevel.IGNORE, RecipeUtils.toEIOInputs(input));
            SliceAndSpliceRecipeManager.getInstance().addRecipe((Recipe)rec);
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from slice'n'splice.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)output);
            IManyToOneRecipe rec = null;
            for (IManyToOneRecipe r : SliceAndSpliceRecipeManager.getInstance().getRecipes()) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)r.getOutput(), (boolean)false)) continue;
                rec = r;
                break;
            }
            if (rec != null) {
                SliceAndSpliceRecipeManager.getInstance().getRecipes().remove(rec);
            } else {
                CraftTweakerAPI.logError((String)("No Slice'n'Splice recipe found for " + output.getDisplayName()));
            }
        });
    }

    public static boolean hasErrors(IItemStack output, IIngredient[] input) {
        if (output == null || output.isEmpty()) {
            CraftTweakerAPI.logError((String)("Invalid output (empty or null) in Slice'n'Splice recipe: " + output));
            return true;
        }
        if (input.length > 6) {
            CraftTweakerAPI.logError((String)("Invalid Slice'n'Splice input, must be between 1 and 6 inputs.  Provided: " + RecipeUtils.getDisplayString(input)));
            return true;
        }
        return false;
    }
}

