/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.basic;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.diagnostics.Prof;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduit;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.ConduitGasTank;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GasConduitNetwork
extends AbstractGasTankConduitNetwork<GasConduit> {
    private int ticksEmpty = 0;
    private int maxFlowsPerTick = 10;
    private int lastFlowIndex = 0;
    private int lastPushToken = 0;
    private boolean inputLocked = false;

    public GasConduitNetwork() {
        super(GasConduit.class);
    }

    public boolean lockNetworkForFill() {
        if (this.inputLocked) {
            return false;
        }
        this.inputLocked = true;
        return true;
    }

    public void unlockNetworkFromFill() {
        this.inputLocked = false;
    }

    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        NNList cons = this.getConduits();
        if (cons.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            if (!this.gasTypeLocked && this.gasType != null) {
                ++this.ticksEmpty;
                if (this.ticksEmpty > 40) {
                    this.setGasType(null);
                    this.ticksEmpty = 0;
                }
            }
            return;
        }
        this.ticksEmpty = 0;
        long curTime = ((GasConduit)cons.get(0)).getBundle().getEntity().func_145831_w().func_82737_E();
        if (this.gasType != null && this.gasType.getGas() != null && !this.isEmpty() && curTime % 2L == 0L) {
            Prof.start((Profiler)profiler, (String)"flow");
            this.doFlow();
            Prof.stop((Profiler)profiler);
        }
    }

    void addedFromExternal(int res) {
    }

    void outputedToExternal(int filled) {
    }

    int getNextPushToken() {
        return ++this.lastPushToken;
    }

    private boolean doFlow() {
        int pushToken = this.getNextPushToken();
        ArrayList<FlowAction> actions = new ArrayList<FlowAction>();
        for (int i = 0; i < Math.min(this.maxFlowsPerTick, this.getConduits().size()); ++i) {
            if (this.lastFlowIndex >= this.getConduits().size()) {
                this.lastFlowIndex = 0;
            }
            this.flowFrom((GasConduit)this.getConduits().get(this.lastFlowIndex), actions, pushToken);
            ++this.lastFlowIndex;
        }
        actions.forEach(rec$ -> ((FlowAction)rec$).apply());
        boolean result = !actions.isEmpty();
        ArrayList<GasConduit> toEmpty = new ArrayList<GasConduit>();
        for (GasConduit con2 : this.getConduits()) {
            if (con2 != null && con2.getTank().getStored() < 10) {
                toEmpty.add(con2);
                continue;
            }
            return result;
        }
        if (toEmpty.isEmpty()) {
            return result;
        }
        ArrayList<LocatedGasHandler> externals = new ArrayList<LocatedGasHandler>();
        for (AbstractGasTankConduit con3 : this.getConduits()) {
            Set extCons = con3.getExternalConnections();
            for (EnumFacing dir : extCons) {
                IGasHandler externalTank;
                if (!con3.canOutputToDir(dir) || (externalTank = con3.getExternalHandler(dir)) == null) continue;
                externals.add(new LocatedGasHandler(externalTank, con3.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d()));
            }
        }
        if (externals.isEmpty()) {
            return result;
        }
        toEmpty.forEach(con -> this.drainConduitToNearestExternal((GasConduit)con, (List<LocatedGasHandler>)externals));
        return result;
    }

    @Override
    public void setGasTypeLocked(boolean gasTypeLocked) {
        super.setGasTypeLocked(gasTypeLocked);
        if (!gasTypeLocked && this.isEmpty()) {
            this.setGasType(null);
        }
    }

    private boolean isEmpty() {
        return this.getConduits().stream().noneMatch(con -> con.getTank().getStored() > 0);
    }

    private void drainConduitToNearestExternal(@Nonnull GasConduit con, List<LocatedGasHandler> externals) {
        BlockPos conPos = con.getBundle().getLocation();
        GasStack toDrain = con.getTank().getGas();
        if (toDrain == null) {
            return;
        }
        int closestDistance = Integer.MAX_VALUE;
        LocatedGasHandler closestTank = null;
        for (LocatedGasHandler lh : externals) {
            int couldFill;
            int distance = (int)lh.pos.func_177951_i((Vec3i)conPos);
            if (distance >= closestDistance || !con.canOutputToDir(lh.dir.func_176734_d()) || (couldFill = lh.tank.receiveGas(lh.dir, toDrain.copy(), false)) <= 0) continue;
            closestTank = lh;
            closestDistance = distance;
        }
        if (closestTank != null) {
            int filled = closestTank.tank.receiveGas(closestTank.dir, toDrain.copy(), true);
            con.getTank().addAmount(-filled);
        }
    }

    private void flowFrom(@Nonnull GasConduit con, List<FlowAction> actions, int pushPoken) {
        ConduitGasTank tank = con.getTank();
        int totalAmount = tank.getStored();
        if (totalAmount <= 0) {
            return;
        }
        GasStack available = tank.getGas();
        if (available == null) {
            return;
        }
        int totalRequested = 0;
        int numRequests = 0;
        for (EnumFacing dir : con.getExternalConnections()) {
            int amount;
            IGasHandler extCon;
            if (!con.canOutputToDir(dir) || (extCon = con.getExternalHandler(dir)) == null || !extCon.canReceiveGas(dir.func_176734_d(), available.getGas()) || (amount = extCon.receiveGas(dir.func_176734_d(), available.copy(), false)) <= 0) continue;
            totalRequested += amount;
            ++numRequests;
        }
        int maxFlowVolume = 20;
        if (numRequests > 0) {
            int amountPerRequest = Math.min(totalAmount, totalRequested) / numRequests;
            amountPerRequest = Math.min(maxFlowVolume, amountPerRequest);
            GasStack requestSource = available.copy();
            requestSource.amount = amountPerRequest;
            for (Object dir : con.getExternalConnections()) {
                int amount;
                IGasHandler extCon;
                if (!con.canOutputToDir((EnumFacing)dir) || (extCon = con.getExternalHandler((EnumFacing)dir)) == null || !extCon.canReceiveGas(dir.func_176734_d(), requestSource.getGas()) || (amount = extCon.receiveGas(dir.func_176734_d(), requestSource.copy(), true)) <= 0) continue;
                this.outputedToExternal(amount);
                tank.addAmount(-amount);
            }
        }
        if ((totalAmount = tank.getStored()) <= 0) {
            return;
        }
        int totalCapacity = tank.getMaxGas();
        try {
            BlockPos pos = con.getBundle().getLocation();
            Collection connections = ConduitUtil.getConnectedConduits((World)con.getBundle().getEntity().func_145831_w(), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), IGasConduit.class);
            for (IGasConduit n : connections) {
                GasConduit neighbour = (GasConduit)n;
                if (!this.canFlowTo(con, neighbour)) continue;
                totalAmount += neighbour.getTank().getStored();
                totalCapacity += neighbour.getTank().getMaxGas();
            }
            float targetRatio = (float)totalAmount / (float)totalCapacity;
            int flowVolume = (int)Math.floor((targetRatio - tank.getFilledRatio()) * (float)tank.getMaxGas());
            if (Math.abs(flowVolume = Math.min(maxFlowVolume, flowVolume)) < 2) {
                return;
            }
            for (IGasConduit n : connections) {
                GasConduit neighbour = (GasConduit)n;
                if (!this.canFlowTo(con, neighbour) || (flowVolume = (int)Math.floor((targetRatio - neighbour.getTank().getFilledRatio()) * (float)neighbour.getTank().getMaxGas())) == 0) continue;
                actions.add(new FlowAction(con, neighbour, flowVolume));
            }
        }
        catch (ConduitUtil.UnloadedBlockException unloadedBlockException) {
            // empty catch block
        }
    }

    private boolean canFlowTo(GasConduit con, GasConduit neighbour) {
        if (con == null || neighbour == null) {
            return false;
        }
        if (neighbour.getNetwork() != this) {
            return false;
        }
        return neighbour.getTank().getFilledRatio() < con.getTank().getFilledRatio();
    }

    private static class LocatedGasHandler {
        private final IGasHandler tank;
        private final BlockPos pos;
        private final EnumFacing dir;

        private LocatedGasHandler(IGasHandler tank, BlockPos pos, EnumFacing dir) {
            this.tank = tank;
            this.pos = pos;
            this.dir = dir;
        }
    }

    private static class FlowAction {
        private final GasConduit from;
        private final GasConduit to;
        private final int amount;

        private FlowAction(GasConduit fromIn, GasConduit toIn, int amountIn) {
            if (amountIn < 0) {
                this.to = fromIn;
                this.from = toIn;
                this.amount = -amountIn;
            } else {
                this.to = toIn;
                this.from = fromIn;
                this.amount = amountIn;
            }
        }

        private void apply() {
            if (this.amount != 0) {
                int actual = Math.min(this.amount, this.from.getTank().getStored());
                actual = Math.min(actual, this.to.getTank().getNeeded());
                this.from.getTank().addAmount(-actual);
                this.to.getTank().addAmount(actual);
            }
        }
    }
}

