/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.common.vecmath.Vector2i;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public abstract class RecipeWrapperBase
implements IRecipeWrapper {
    private static final Map<Class<? extends RecipeWrapperBase>, Triple<IDrawable, IDrawable, Vector2i>> LEVEL = new IdentityHashMap<Class<? extends RecipeWrapperBase>, Triple<IDrawable, IDrawable, Vector2i>>();

    protected abstract RecipeLevel getRecipeLevel();

    public static void setLevelData(@Nonnull Class<? extends RecipeWrapperBase> clazz, @Nonnull IGuiHelper guiHelper, int x, int y, String textureSimple, String textureNormal) {
        IDrawableStatic simpleFront = textureSimple != null ? guiHelper.createDrawable(new ResourceLocation("enderio", textureSimple), 0, 0, 16, 16, 16, 16) : null;
        IDrawableStatic normalFront = textureNormal != null ? guiHelper.createDrawable(new ResourceLocation("enderio", textureNormal), 0, 0, 16, 16, 16, 16) : null;
        LEVEL.put(clazz, (Triple<IDrawable, IDrawable, Vector2i>)Triple.of((Object)simpleFront, normalFront, (Object)new Vector2i(x, y)));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Triple<IDrawable, IDrawable, Vector2i> level = LEVEL.get(this.getClass());
        if (level != null) {
            switch (this.getRecipeLevel()) {
                case ADVANCED: {
                    if (level.getMiddle() == null) break;
                    ((IDrawable)level.getMiddle()).draw(minecraft, ((Vector2i)level.getRight()).x, ((Vector2i)level.getRight()).y);
                    break;
                }
                case NORMAL: {
                    if (level.getLeft() == null) break;
                    ((IDrawable)level.getLeft()).draw(minecraft, ((Vector2i)level.getRight()).x, ((Vector2i)level.getRight()).y);
                    break;
                }
                default: {
                    return;
                }
            }
            IconEIO.map.render((IWidgetIcon)IconEIO.GENERIC_VERBOTEN, (double)(((Vector2i)level.getRight()).x + 6), (double)(((Vector2i)level.getRight()).y - 6), true);
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        Triple<IDrawable, IDrawable, Vector2i> level = LEVEL.get(this.getClass());
        if (level != null && mouseX >= ((Vector2i)level.getRight()).x && mouseX <= ((Vector2i)level.getRight()).x + 6 + 16 && mouseY >= ((Vector2i)level.getRight()).y - 6 && mouseY <= ((Vector2i)level.getRight()).y + 16) {
            switch (this.getRecipeLevel()) {
                case ADVANCED: {
                    return Lang.JEI_NOTNORMAL.getLines(new Object[0]);
                }
                case NORMAL: {
                    return Lang.JEI_NOTSIMPLE.getLines(new Object[0]);
                }
            }
        }
        return super.getTooltipStrings(mouseX, mouseY);
    }
}

