/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class DarkSteelRepairRecipe {
    @SubscribeEvent
    public static void handleAnvilEvent(AnvilUpdateEvent evt) {
        ItemStack targetStack;
        IDarkSteelItem item;
        if (evt.getLeft().func_190916_E() == 1 && evt.getLeft().func_77973_b() instanceof IDarkSteelItem && (item = (IDarkSteelItem)(targetStack = evt.getLeft()).func_77973_b()).isItemForRepair(evt.getRight())) {
            int maxDamage;
            int damage;
            double damPerc;
            int requiredIngots;
            ItemStack ingots = evt.getRight();
            int maxIngots = item.getIngotsRequiredForFullRepair();
            int ingouts = ingots.func_190916_E();
            if (ingouts > (requiredIngots = (int)Math.ceil((damPerc = (double)(damage = targetStack.func_77952_i()) / (double)(maxDamage = targetStack.func_77958_k())) * (double)maxIngots))) {
                ingouts = requiredIngots;
            }
            int damageAddedPerIngot = (int)Math.ceil((double)maxDamage / (double)maxIngots);
            int totalDamageRemoved = damageAddedPerIngot * ingouts;
            ItemStack resultStack = targetStack.func_77946_l();
            resultStack.func_77964_b(Math.max(0, damage - totalDamageRemoved));
            evt.setOutput(resultStack);
            evt.setCost(ingouts + (int)Math.ceil((double)DarkSteelRepairRecipe.getEnchantmentRepairCost(resultStack.func_77946_l()) / 2.0));
            evt.setMaterialCost(ingouts);
        }
    }

    private static int getEnchantmentRepairCost(@Nonnull ItemStack itemStack) {
        int res = 0;
        Map map1 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        Iterator iter = map1.keySet().iterator();
        while (iter.hasNext()) {
            Enchantment i1;
            Enchantment enchantment = i1 = (Enchantment)iter.next();
            int level = (Integer)map1.get(enchantment);
            if (!enchantment.func_92089_a(itemStack)) continue;
            if (level > enchantment.func_77325_b()) {
                level = enchantment.func_77325_b();
            }
            int costPerLevel = 0;
            switch (enchantment.func_77324_c()) {
                case VERY_RARE: {
                    costPerLevel = 8;
                    break;
                }
                case RARE: {
                    costPerLevel = 4;
                    break;
                }
                case UNCOMMON: {
                    costPerLevel = 2;
                    break;
                }
                case COMMON: {
                    costPerLevel = 1;
                }
            }
            res += costPerLevel * level;
        }
        return res;
    }
}

