/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.potion.PotionUtil;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class ItemOptional
implements IRecipeConfigElement {
    protected transient boolean allowDelaying = false;
    protected Optional<String> name = this.empty();
    protected Optional<String> nbt = this.empty();
    protected Optional<String> potion = this.empty();
    protected transient boolean nullItem;
    protected final transient Things thing = new Things();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.potion.isPresent()) {
            if (this.nbt.isPresent()) {
                throw new InvalidRecipeConfigException("Cannot have nbt on a potion");
            }
            PotionType potionType = PotionType.func_185168_a((String)this.get(this.potion));
            if (potionType == null) {
                throw new InvalidRecipeConfigException("'" + this.get(this.potion) + "' is not a valid potion name");
            }
            ItemStack stack = PotionUtils.func_185188_a((ItemStack)PotionUtil.getEmptyPotion(false), (PotionType)potionType);
            if (!this.name.isPresent()) {
                this.name = this.ofString("item:" + NullHelper.first((Object[])new Object[]{stack.func_77973_b().getRegistryName(), ""}).toString());
            }
            this.nbt = this.ofString(NullHelper.first((Object[])new Object[]{stack.func_77978_p(), ""}).toString());
        }
        if (!this.name.isPresent()) {
            if (this.nbt.isPresent()) {
                throw new InvalidRecipeConfigException("Cannot have nbt on an empty item");
            }
            this.nullItem = true;
            return this;
        }
        this.thing.add(this.get(this.name));
        if (this.nbt.isPresent()) {
            try {
                this.thing.setNbt(JsonToNBT.func_180713_a((String)this.get(this.nbt)));
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException("'" + this.nbt.get() + "' is not valid NBT json");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            throw new InvalidRecipeConfigException("Could not find a crafting ingredient for '" + this.name.get() + "'");
        }
    }

    @Override
    public boolean isValid() {
        return this.nullItem || (this.allowDelaying ? this.thing.isPotentiallyValid() : this.thing.isValid());
    }

    @Nullable
    public Ingredient getRecipeObject() {
        return this.nullItem ? null : this.thing.asIngredient();
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.thing.getItemStack();
        itemStack.func_190920_e(1);
        return itemStack;
    }

    public void setName(String name) {
        this.name = this.ofString(name);
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = this.ofString(value);
            return true;
        }
        if ("potion".equals(name)) {
            this.potion = this.ofString(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    public Things getThing() {
        return this.thing;
    }

    public <T extends ItemOptional> T setAllowDelaying(boolean allowDelaying) {
        this.allowDelaying = allowDelaying;
        return (T)this;
    }

    public boolean isSame(ItemOptional other) {
        return this.name.isPresent() && this.name.equals(other.name) && this.nbt.equals(other.nbt);
    }
}

