/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class DislocatorLinkHandler
extends WorldSavedData {
    private static final String SAVE_DATA_NAME = "DECustomData";
    public Map<String, LinkData> linkDataMap = new HashMap<String, LinkData>();

    public DislocatorLinkHandler(String name) {
        super(name);
    }

    @Nullable
    public static DislocatorLinkHandler getDataInstance(World world) {
        MapStorage storage = world.func_175693_T();
        if (storage == null) {
            LogHelper.bigError("Detected null MapStorage! This may cause issues!", new Object[0]);
            return null;
        }
        WorldSavedData data = storage.func_75742_a(DislocatorLinkHandler.class, SAVE_DATA_NAME);
        if (data != null && data instanceof DislocatorLinkHandler) {
            return (DislocatorLinkHandler)data;
        }
        data = new DislocatorLinkHandler(SAVE_DATA_NAME);
        storage.func_75745_a(SAVE_DATA_NAME, data);
        data.func_76185_a();
        storage.func_75744_a();
        return (DislocatorLinkHandler)data;
    }

    public static void updateLink(World world, ItemStack stack, BlockPos pos, int dimension) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEFeatures.dislocatorBound.isValid(stack)) {
            return;
        }
        String linkID = DEFeatures.dislocatorBound.getLinkID(stack);
        LinkData link = data.linkDataMap.computeIfAbsent(linkID, s -> new LinkData(linkID, data));
        link.setTarget(pos, dimension);
    }

    public static void updateLink(World world, ItemStack stack, EntityPlayer player) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEFeatures.dislocatorBound.isValid(stack)) {
            return;
        }
        String linkID = DEFeatures.dislocatorBound.getLinkID(stack);
        LinkData link = data.linkDataMap.computeIfAbsent(linkID, s -> new LinkData(linkID, data));
        link.setTarget(player.func_146103_bH().getId().toString());
    }

    public static void removeLink(World world, ItemStack stack) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEFeatures.dislocatorBound.isValid(stack)) {
            return;
        }
        String linkID = DEFeatures.dislocatorBound.getLinkID(stack);
        data.linkDataMap.remove(linkID);
        data.func_76185_a();
    }

    public static Vec3D getLinkPos(World world, ItemStack stack) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || !DEFeatures.dislocatorBound.isValid(stack)) {
            return null;
        }
        if (DEFeatures.dislocatorBound.isPlayer(stack)) {
            return DislocatorLinkHandler.getPlayerPos(ItemNBTHelper.getString((ItemStack)stack, (String)"PlayerLink", (String)"null"), world);
        }
        String linkID = DEFeatures.dislocatorBound.getLinkToID(stack);
        LinkData link = data.linkDataMap.get(linkID);
        if (link != null) {
            if (link.isPlayer) {
                return DislocatorLinkHandler.getAndValidatePlayerPos(world, data, link, linkID);
            }
            return DislocatorLinkHandler.getTileOrEntityPos(link, linkID);
        }
        return null;
    }

    public static Vec3D getLinkPos(World world, String linkID) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null) {
            return null;
        }
        LinkData link = data.linkDataMap.get(linkID);
        if (link != null) {
            if (link.isPlayer) {
                return DislocatorLinkHandler.getAndValidatePlayerPos(world, data, link, linkID);
            }
            return DislocatorLinkHandler.getTileOrEntityPos(link, linkID);
        }
        return null;
    }

    public static TileEntity getTargetTile(World world, ItemStack stack) {
        String linkID;
        LinkData link;
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || !DEFeatures.dislocatorBound.isValid(stack)) {
            return null;
        }
        if (!DEFeatures.dislocatorBound.isPlayer(stack) && (link = data.linkDataMap.get(linkID = DEFeatures.dislocatorBound.getLinkToID(stack))) != null && !link.isPlayer) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null || !DimensionManager.isDimensionRegistered((int)link.dimension)) {
                return null;
            }
            WorldServer targetWorld = server.func_71218_a(link.dimension);
            TileEntity tile = targetWorld.func_175625_s(link.pos);
            if (tile instanceof ITeleportEndPoint) {
                return tile;
            }
        }
        return null;
    }

    private static Vec3D getAndValidatePlayerPos(World world, DislocatorLinkHandler data, LinkData link, String linkID) {
        if (world.func_73046_m() == null) {
            return null;
        }
        PlayerList players = world.func_73046_m().func_184103_al();
        EntityPlayerMP player = players.func_177451_a(UUID.fromString(link.playerUUID));
        if (player == null) {
            return null;
        }
        boolean flag = DataUtils.firstMatch((Iterable)player.field_71071_by.field_70462_a, stack -> DEFeatures.dislocatorBound.isValid((ItemStack)stack) && DEFeatures.dislocatorBound.getLinkID((ItemStack)stack).equals(linkID)) != null;
        boolean bl = flag = flag || DataUtils.firstMatch((Iterable)player.field_71071_by.field_184439_c, stack -> DEFeatures.dislocatorBound.isValid((ItemStack)stack) && DEFeatures.dislocatorBound.getLinkID((ItemStack)stack).equals(linkID)) != null;
        if (!flag) {
            data.linkDataMap.remove(linkID);
            data.func_76185_a();
            return null;
        }
        return new Vec3D((Entity)player);
    }

    private static Vec3D getTileOrEntityPos(LinkData link, String linkID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null || !DimensionManager.isDimensionRegistered((int)link.dimension)) {
            return null;
        }
        WorldServer targetWorld = server.func_71218_a(link.dimension);
        TileEntity tile = targetWorld.func_175625_s(link.pos);
        if (tile instanceof ITeleportEndPoint) {
            BlockPos tilePos = ((ITeleportEndPoint)tile).getArrivalPos(linkID);
            if (tilePos == null) {
                return null;
            }
            return new Vec3D((double)tilePos.func_177958_n() + 0.5, (double)tilePos.func_177956_o() + 0.2, (double)tilePos.func_177952_p() + 0.5);
        }
        AxisAlignedBB bb = new AxisAlignedBB(link.pos, link.pos.func_177982_a(1, 1, 1));
        bb.func_186662_g(5.0);
        List items = targetWorld.func_72872_a(EntityPersistentItem.class, bb);
        for (EntityPersistentItem item : items) {
            String l;
            ItemStack i = item.func_92059_d();
            if (!DEFeatures.dislocatorBound.isValid(i) || !(l = DEFeatures.dislocatorBound.getLinkID(i)).equals(linkID)) continue;
            return new Vec3D((Entity)item);
        }
        return null;
    }

    public static LinkData getLink(ItemStack stack, World world) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || !DEFeatures.dislocatorBound.isValid(stack)) {
            return null;
        }
        return data.linkDataMap.get(DEFeatures.dislocatorBound.getLinkToID(stack));
    }

    public static Vec3D getPlayerPos(String playerID, World world) {
        if (world.func_73046_m() == null) {
            return null;
        }
        PlayerList players = world.func_73046_m().func_184103_al();
        EntityPlayerMP player = players.func_177451_a(UUID.fromString(playerID));
        return player == null ? null : new Vec3D((Entity)player);
    }

    public static boolean validateStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == DEFeatures.dislocatorBound && stack.func_77942_o() && stack.func_77960_j() == 0;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.linkDataMap.clear();
        NBTTagList dataList = nbt.func_150295_c("LinkList", 10);
        dataList.forEach(nbtBase -> {
            LinkData data = new LinkData(this).fromNBT((NBTTagCompound)nbtBase);
            this.linkDataMap.put(data.linkID, data);
        });
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList dataList = new NBTTagList();
        this.linkDataMap.forEach((id, linkData) -> dataList.func_74742_a((NBTBase)linkData.toNBT(new NBTTagCompound())));
        compound.func_74782_a("LinkList", (NBTBase)dataList);
        return compound;
    }

    public static class LinkData {
        private String linkID;
        public DislocatorLinkHandler handler;
        public BlockPos pos = new BlockPos(0, 128, 0);
        public int dimension = 0;
        private String playerUUID;
        public boolean isPlayer = false;

        public LinkData(DislocatorLinkHandler handler) {
            this.handler = handler;
        }

        public LinkData(String linkID, DislocatorLinkHandler handler) {
            this.linkID = linkID;
            this.handler = handler;
        }

        public void setTarget(BlockPos pos, int dimension) {
            this.pos = pos;
            this.dimension = dimension;
            this.isPlayer = false;
            this.handler.func_76185_a();
        }

        public void setTarget(String playerUUID) {
            this.playerUUID = playerUUID;
            this.isPlayer = true;
            this.handler.func_76185_a();
        }

        public NBTTagCompound toNBT(NBTTagCompound compound) {
            compound.func_74778_a("LinkID", this.linkID);
            compound.func_74757_a("IsPlayer", this.isPlayer);
            compound.func_74768_a("Dim", this.dimension);
            if (this.isPlayer) {
                compound.func_74778_a("PlayerID", this.playerUUID);
            } else {
                compound.func_74772_a("Pos", this.pos.func_177986_g());
            }
            return compound;
        }

        public LinkData fromNBT(NBTTagCompound compound) {
            this.linkID = compound.func_74779_i("LinkID");
            this.isPlayer = compound.func_74767_n("IsPlayer");
            this.dimension = compound.func_74762_e("Dim");
            if (this.isPlayer) {
                this.playerUUID = compound.func_74779_i("PlayerID");
            } else {
                this.pos = BlockPos.func_177969_a((long)compound.func_74763_f("Pos"));
            }
            return this;
        }
    }
}

