/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata;

import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WikiDownloadManager {
    public static List<ManifestEntry> manifest = new ArrayList<ManifestEntry>();
    public static List<DownloadThread> dlThreads = Collections.synchronizedList(new ArrayList());
    public static DLMonitor monitor = null;

    public static void downloadManifest() {
        if (WikiConfig.editMode) {
            LogHelper.info("Wiki is in edit mode. Canceling update check!");
            return;
        }
        if (!WikiConfig.docLocation.equals("[CONFIG]")) {
            LogHelper.info("Wiki document home location has been changed! Canceling update check!");
            return;
        }
        LogHelper.info("Downloading Project Intelligence Mod Manifest...");
        DownloadThread thread = new DownloadThread("https://raw.githubusercontent.com/brandon3055/Project-Intelligence-Docs/master/ModDocs/manifest.json", WikiDocManager.wikiFolder.getAbsolutePath() + "/manifest.json");
        thread.setDaemon(true);
        thread.start();
        ProcessHandlerClient.addProcess((IProcess)new ManifestDLMonitor(thread));
    }

    public static void downloadDocs() {
        LogHelper.info("Checking Doc Versions");
        File modDocs = new File(WikiDocManager.wikiFolder, "ModDocs");
        if (!modDocs.exists() && !modDocs.mkdirs()) {
            LogHelper.error("Can not download mod documentation because could not create the ModDocs folder: " + modDocs);
            return;
        }
        for (ManifestEntry entry : manifest) {
            File mod = new File(modDocs, entry.modName);
            if (!mod.exists() && !mod.mkdirs()) {
                LogHelper.error("Can not download mod documentation because could not create the mod folder: " + mod);
                return;
            }
            LogHelper.dev("Checking Manifest: " + manifest);
            for (String url : entry.downloadToVersion.keySet()) {
                try {
                    String lang = url.substring(url.lastIndexOf("-") + 1).replace(".xml", "");
                    if (WikiDocManager.modDocMap.containsKey(entry.modid) && WikiDocManager.modDocMap.get((Object)entry.modid).langToVersion.containsKey(lang)) {
                        LogHelper.dev("Version : " + WikiDocManager.modDocMap.get((Object)entry.modid).langToVersion.get(lang));
                    }
                    if (WikiDocManager.modDocMap.containsKey(entry.modid) && WikiDocManager.modDocMap.get((Object)entry.modid).langToVersion.containsKey(lang) && WikiDocManager.modDocMap.get((Object)entry.modid).langToVersion.get(lang) >= entry.downloadToVersion.get(url)) {
                        LogHelper.dev(entry.modName + ": Current Doc Version Up To Date.");
                        continue;
                    }
                    LogHelper.info("Found Doc update for %s downloading updated documentation.", entry.modName);
                    DownloadThread thread = new DownloadThread(url, new File(mod, entry.modid + "-" + lang + ".xml").getAbsolutePath());
                    thread.start();
                    dlThreads.add(thread);
                    if (monitor != null) continue;
                    monitor = new DLMonitor();
                    ProcessHandlerClient.addProcess((IProcess)monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ManifestEntry {
        public final String modName;
        public final String modid;
        public final Map<String, Integer> downloadToVersion;

        public ManifestEntry(String modName, String modid, Map<String, Integer> downloadToVersion) {
            this.modName = modName;
            this.modid = modid;
            this.downloadToVersion = downloadToVersion;
        }

        public String toString() {
            return String.format("Name: %s, ModId: %s, Downloads: %s", this.modName, this.modid, this.downloadToVersion);
        }
    }

    private static class DLWatcher
    extends Thread {
        private DownloadThread targetThread;
        private double lastCheckProgress = 0.0;

        public DLWatcher(DownloadThread targetThread) {
            this.targetThread = targetThread;
        }

        @Override
        public void run() {
            try {
                while (!this.targetThread.finished) {
                    Thread.sleep(30000L);
                    if (this.targetThread.progress <= this.lastCheckProgress) {
                        this.targetThread.finished = true;
                        this.targetThread.failed = true;
                        this.targetThread.interrupt();
                        LogHelper.error("Download Timed Out: " + this.targetThread.url);
                        break;
                    }
                    this.lastCheckProgress = this.targetThread.progress;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static class DownloadThread
    extends Thread {
        public final String url;
        public final String file;
        public volatile boolean finished = false;
        public volatile boolean failed = false;
        public volatile double progress = 0.0;

        public DownloadThread(String url, String file) {
            super("Wiki Download Thread");
            this.url = url;
            this.file = file;
            LogHelper.dev(String.format("Download: %s -> %s", url, file));
            DLWatcher watcher = new DLWatcher(this);
            watcher.setDaemon(true);
            watcher.start();
        }

        @Override
        public void run() {
            try {
                int n;
                URL url = new URL(this.url);
                File outputFile = new File(this.file);
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                LogHelper.dev("Got URL: " + url);
                InputStream is = url.openStream();
                FileOutputStream os = new FileOutputStream(outputFile);
                LogHelper.dev("Starting Copy...");
                byte[] buffer = new byte[4096];
                long size = is.available();
                long count = 0L;
                while (-1 != (n = is.read(buffer))) {
                    ((OutputStream)os).write(buffer, 0, n);
                    this.progress = (double)(count += (long)n) / (double)size;
                }
                is.close();
                ((OutputStream)os).close();
                LogHelper.dev("Download Complete");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.failed = true;
                LogHelper.dev("Download Failed");
            }
            this.finished = true;
        }
    }

    public static class ManifestDLMonitor
    implements IProcess {
        private DownloadThread thread;
        private boolean isDead = false;

        public ManifestDLMonitor(DownloadThread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateProcess() {
            if (this.thread.failed) {
                LogHelper.error("Failed to download mod manifest.");
                this.isDead = true;
            } else if (this.thread.finished) {
                try {
                    JsonReader reader = new JsonReader((Reader)new FileReader(this.thread.file));
                    manifest.clear();
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        String modName = "";
                        String modId = "";
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (reader.hasNext()) {
                            String name;
                            switch (name = reader.nextName()) {
                                case "name": {
                                    modName = reader.nextString();
                                    break;
                                }
                                case "modid": {
                                    modId = reader.nextString();
                                    break;
                                }
                                case "downloads": {
                                    reader.beginObject();
                                    while (reader.hasNext()) {
                                        String url = reader.nextName();
                                        int revision = reader.nextInt();
                                        map.put(url, revision);
                                    }
                                    reader.endObject();
                                }
                            }
                        }
                        manifest.add(new ManifestEntry(modName, modId, map));
                        reader.endObject();
                    }
                    reader.endArray();
                    WikiDownloadManager.downloadDocs();
                }
                catch (Exception e) {
                    LogHelper.error("Failed to load manifest!");
                    e.printStackTrace();
                }
                finally {
                    this.isDead = true;
                }
            }
        }

        public boolean isDead() {
            return this.isDead;
        }
    }

    public static class DLMonitor
    implements IProcess {
        public boolean isDead = false;

        public void updateProcess() {
            boolean foundActive = false;
            for (DownloadThread thread : dlThreads) {
                if (thread.failed) {
                    LogHelper.dev("Download Failed: " + thread.url);
                    thread.failed = false;
                    continue;
                }
                if (thread.finished) continue;
                foundActive = true;
            }
            if (!foundActive) {
                this.isDead = true;
                monitor = null;
                LogHelper.dev("All " + dlThreads.size() + " Downloads Complete.");
                dlThreads.clear();
                WikiDocManager.reload(true, true, true);
            }
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

