/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.integration.BaublesHelper;
import com.brandon3055.draconicevolution.integration.ModHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.foxmcloud.draconicadditions.entity.EntityPlug;
import net.foxmcloud.draconicadditions.lib.DASoundHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PortableWiredCharger
extends ItemEnergyBase {
    public static final int basicTransfer = 100000;
    public static final int wyvernTransfer = 800000;
    public static final int draconicTransfer = 6400000;
    public static final int chaoticTransfer = 51200000;
    public boolean active = false;
    public double maxDistance = 3.0;

    public PortableWiredCharger() {
        this.func_77627_a(true);
        this.addName(0, "basic").addName(1, "wyvern").addName(2, "draconic").addName(3, "chaotic");
        this.addName(4, "basic").addName(5, "wyvern").addName(6, "draconic").addName(7, "chaotic");
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)DAFeatures.pwc, 1, 0));
            subItems.add((Object)new ItemStack((Item)DAFeatures.pwc, 1, 1));
            subItems.add((Object)new ItemStack((Item)DAFeatures.pwc, 1, 2));
            subItems.add((Object)new ItemStack((Item)DAFeatures.pwc, 1, 3));
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public int getCapacity(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: 
            case 4: {
                return 100000;
            }
            case 1: 
            case 5: {
                return 800000;
            }
            case 2: 
            case 6: {
                return 6400000;
            }
            case 3: 
            case 7: {
                return 51200000;
            }
        }
        return 0;
    }

    public int getMaxReceive(ItemStack stack) {
        return this.getCapacity(stack);
    }

    public int getMaxExtract(ItemStack stack) {
        return this.getCapacity(stack);
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)false)) {
            this.unplug(stack, player);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult trace = this.func_77621_a(world, player, false);
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && this.isDistanceValid(trace.func_178782_a(), trace.field_178784_b, player)) {
            BlockPos pos = trace.func_178782_a();
            if (world.func_180495_p(pos).func_177230_c().hasTileEntity(world.func_180495_p(pos))) {
                TileEntity te = world.func_175625_s(pos);
                if (EnergyHelper.isEnergyTile((TileEntity)te, null)) {
                    if (EnergyHelper.isEnergyTile((TileEntity)te, (EnumFacing)trace.field_178784_b)) {
                        Vec3D vec = Vec3D.getCenter((BlockPos)trace.func_178782_a());
                        if (!world.field_72995_K) {
                            DASoundHandler.playSoundFromServer((World)world, (Vec3D)vec, (SoundEvent)DASoundHandler.unplug, (SoundCategory)SoundCategory.BLOCKS, (float)0.8f, (float)1.5f, (boolean)false, (double)64.0);
                        }
                        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)true);
                        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockX", (int)vec.floorX());
                        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockY", (int)vec.floorY());
                        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockZ", (int)vec.floorZ());
                        ItemNBTHelper.setString((ItemStack)stack, (String)"blockSide", (String)trace.field_178784_b.func_176610_l());
                        world.func_72838_d((Entity)new EntityPlug(world, player, vec, trace.field_178784_b));
                    } else if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.portableWiredCharger.invalidSide", new Object[0]), true);
                    }
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.portableWiredCharger.connectEnergySource", new Object[0]), true);
                }
            } else if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.portableWiredCharger.connectEnergySource", new Object[0]), true);
            }
        } else if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.portableWiredCharger.connectEnergySource", new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof EntityPlayer) || world.field_72995_K) {
            return;
        }
        this.updateActive(stack);
        EntityPlayer player = (EntityPlayer)entity;
        if (this.active) {
            if (player.func_184614_ca() != stack && player.func_184592_cb() != stack) {
                this.unplug(stack, player);
            } else if (this.getTileEntity(stack, world) != null) {
                this.checkDistance(stack, world, player);
                this.extractEnergyFromSource(stack, world);
            } else {
                this.unplug(stack, player);
            }
        }
        if (this.getEnergyStored(stack) > 0) {
            if (ModHelper.isBaublesInstalled) {
                this.chargeItems(stack, player, PortableWiredCharger.getBaubles(player));
            } else {
                this.chargeItems(stack, player, new ArrayList<ItemStack>());
            }
        }
        if (this.getEnergyStored(stack) > 0) {
            this.sendEnergyToSource(stack, world);
        }
    }

    public void chargeItems(ItemStack charger, EntityPlayer player, List<ItemStack> stacks) {
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
        for (ItemStack stack : stacks) {
            if (this.getEnergyStored(charger) == 0) break;
            if (stack.func_190926_b() || !EnergyHelper.canReceiveEnergy((ItemStack)stack)) continue;
            int max = Math.min(this.getEnergyStored(charger), this.getMaxExtract(charger));
            int insertedEnergy = EnergyHelper.insertEnergy((ItemStack)stack, (int)Math.min(this.getMaxExtract(charger), max), (boolean)false);
            super.extractEnergy(charger, insertedEnergy, false);
        }
    }

    public void extractEnergyFromSource(ItemStack stack, World world) {
        if (this.active) {
            TileEntity te = this.getTileEntity(stack, world);
            EnumFacing extractSide = EnumFacing.func_176739_a((String)ItemNBTHelper.getString((ItemStack)stack, (String)"blockSide", (String)"NONE"));
            if (te != null && EnergyHelper.canExtractEnergy((TileEntity)te, (EnumFacing)extractSide)) {
                int storedEnergy = ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0);
                int energyToExtract = Math.min(this.getCapacity(stack) - storedEnergy, EnergyHelper.getEnergyStored((TileEntity)te, (EnumFacing)extractSide));
                if (energyToExtract == 0) {
                    return;
                }
                ItemNBTHelper.setInteger((ItemStack)stack, (String)"Energy", (int)(storedEnergy += EnergyHelper.extractEnergy((TileEntity)te, (int)energyToExtract, (EnumFacing)extractSide, (boolean)false)));
            }
        }
    }

    public void sendEnergyToSource(ItemStack stack, World world) {
        if (this.active) {
            TileEntity te = this.getTileEntity(stack, world);
            EnumFacing insertSide = EnumFacing.func_176739_a((String)ItemNBTHelper.getString((ItemStack)stack, (String)"blockSide", (String)"NONE"));
            if (te != null && EnergyHelper.canReceiveEnergy((TileEntity)te, (EnumFacing)insertSide)) {
                int storedEnergy = ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0);
                int energyToSend = this.getCapacity(stack) - storedEnergy;
                if (energyToSend == 0) {
                    return;
                }
                ItemNBTHelper.setInteger((ItemStack)stack, (String)"Energy", (int)(storedEnergy -= EnergyHelper.insertEnergy((TileEntity)te, (int)energyToSend, (EnumFacing)insertSide, (boolean)false)));
            }
        }
    }

    public void checkDistance(ItemStack stack, World world, EntityPlayer player) {
        TileEntity te = this.getTileEntity(stack, world);
        if (te != null) {
            EnumFacing side = EnumFacing.func_176739_a((String)ItemNBTHelper.getString((ItemStack)stack, (String)"blockSide", (String)"NONE"));
            if (!this.isDistanceValid(te.func_174877_v(), side, player)) {
                this.unplug(stack, player);
            }
        }
    }

    public boolean isDistanceValid(BlockPos pos, EnumFacing side, EntityPlayer player) {
        BlockPos offset = pos.func_177972_a(side).func_177973_b((Vec3i)player.func_180425_c());
        return !((double)Math.abs(offset.func_177958_n()) > this.maxDistance) && !((double)Math.abs(offset.func_177956_o()) > this.maxDistance) && !((double)Math.abs(offset.func_177952_p()) > this.maxDistance);
    }

    public void unplug(ItemStack stack, EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            DASoundHandler.playSoundFromServer((World)player.func_130014_f_(), (Vec3D)Vec3D.getCenter((BlockPos)player.func_180425_c()), (SoundEvent)DASoundHandler.unplug, (SoundCategory)SoundCategory.BLOCKS, (float)0.8f, (float)1.0f, (boolean)false, (double)64.0);
        }
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)false);
        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockX", (int)0);
        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockY", (int)0);
        ItemNBTHelper.setInteger((ItemStack)stack, (String)"blockZ", (int)0);
        ItemNBTHelper.setString((ItemStack)stack, (String)"blockSide", (String)"NONE");
        this.updateActive(stack);
    }

    public TileEntity getTileEntity(ItemStack stack, World world) {
        if (this.active) {
            int x = ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockX", (int)0);
            int y = ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockY", (int)0);
            int z = ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockZ", (int)0);
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            return te;
        }
        return null;
    }

    public void updateActive(ItemStack stack) {
        this.active = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)false);
        int newDamage = stack.func_77952_i() % 4 + (this.active ? 4 : 0);
        if (newDamage != stack.func_77952_i()) {
            stack.func_77964_b(newDamage);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)false);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (this.active) {
            this.unplug(stack, player);
        }
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean isPWC = oldStack.func_77973_b() instanceof PortableWiredCharger && newStack.func_77973_b() instanceof PortableWiredCharger;
        boolean isSameDamage = oldStack.func_77973_b().getDamage(oldStack) % 4 != newStack.func_77973_b().getDamage(newStack) % 4;
        return isPWC && isSameDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (InfoHelper.holdShiftForDetails(tooltip)) {
            boolean pluggedIn = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"pluggedIn", (boolean)false);
            tooltip.add("Plugged In: " + pluggedIn);
            if (pluggedIn) {
                tooltip.add("X: " + ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockX", (int)0));
                tooltip.add("Y: " + ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockY", (int)0));
                tooltip.add("Z: " + ItemNBTHelper.getInteger((ItemStack)stack, (String)"blockZ", (int)0));
                tooltip.add("Side: " + ItemNBTHelper.getString((ItemStack)stack, (String)"blockSide", (String)"NONE"));
            }
        }
        InfoHelper.addEnergyInfo((ItemStack)stack, tooltip);
    }

    private static List<ItemStack> getBaubles(EntityPlayer entity) {
        return BaublesHelper.getBaubles((EntityPlayer)entity);
    }
}

