/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.structure.arcana;

import divinerpg.DivineRPG;
import divinerpg.registry.LootTableRegistry;
import divinerpg.structure.arcana.ArcanaStructureHandler;
import divinerpg.utils.WorldGenUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ArcanaLootRoomHandler
extends ArcanaStructureHandler {
    public ArcanaLootRoomHandler(String name) {
        super(name);
    }

    @Override
    public void handleDataMarkers(World world, Random random, Iterator iterator) {
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BlockPos pos = (BlockPos)entry.getKey();
            switch ((String)entry.getValue()) {
                case "BanquetHallLoot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.BANQUET_HALL_LOOT);
                    break;
                }
                case "UtilityHallwayLoot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.UTILITY_HALLWAY_LOOT);
                    break;
                }
                default: {
                    DivineRPG.logger.warn("Unexpected data marker: " + (String)entry.getValue() + " in a structure, please report this.");
                }
            }
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_185779_df) continue;
            world.func_175698_g(pos);
        }
    }
}

