/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.proxy;

import divinerpg.client.ArcanaRenderer;
import divinerpg.enums.ParticleType;
import divinerpg.events.EventBowZoom;
import divinerpg.events.EventClientLogin;
import divinerpg.objects.entities.assets.render.PlayerHatRender;
import divinerpg.particle.ParticleApalachiaPortal;
import divinerpg.particle.ParticleColored;
import divinerpg.particle.ParticleColoredFlame;
import divinerpg.particle.ParticleEdenPortal;
import divinerpg.particle.ParticleEnderTriplet;
import divinerpg.particle.ParticleFrost;
import divinerpg.particle.ParticleGreenPortal;
import divinerpg.particle.ParticleMortumPortal;
import divinerpg.particle.ParticleSkythernPortal;
import divinerpg.particle.ParticleSparkler;
import divinerpg.particle.ParticleWildwoodPortal;
import divinerpg.proxy.CommonProxy;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.log.DebugLogging;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.EnumHelperClient;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends CommonProxy {
    public static MusicTicker.MusicType Music_Iceika;

    @Override
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    @Deprecated
    public void init(FMLInitializationEvent e) {
        super.init(e);
        DebugLogging.initStageLog();
        Music_Iceika = EnumHelperClient.addMusicType((String)"iceika_music", (SoundEvent)SoundRegistry.ICEIKA_MUSIC, (int)1200, (int)12000);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ArcanaRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new EventClientLogin());
        DebugLogging.postInitStageLog();
        RenderPlayer renderPlayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default");
        if (renderPlayer != null) {
            renderPlayer.func_177094_a((LayerRenderer)new PlayerHatRender(renderPlayer));
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        OBJLoader.INSTANCE.addDomain("divinerpg");
        MinecraftForge.EVENT_BUS.register((Object)new EventBowZoom());
        DebugLogging.preInitStageLog();
    }

    @Override
    public void spawnParticle(World w, double x, double y, double z, String particle, boolean random) {
        this.spawnParticle(w, x, y, z, particle, random);
    }

    @Override
    public void spawnParticle(World world, ParticleType particletype, double x, double y, double z, double velX, double velY, double velZ) {
        if (this.canSpawnParticle(world, x, y, z)) {
            Particle particle = null;
            switch (particletype) {
                case NONE: {
                    break;
                }
                case APALACHIA_PORTAL: {
                    particle = new ParticleApalachiaPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case EDEN_PORTAL: {
                    particle = new ParticleEdenPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case MORTUM_PORTAL: {
                    particle = new ParticleMortumPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case SKYTHERN_PORTAL: {
                    particle = new ParticleSkythernPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case WILDWOOD_PORTAL: {
                    particle = new ParticleWildwoodPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case GREEN_PORTAL: {
                    particle = new ParticleGreenPortal(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case BLACK_FLAME: {
                    particle = new ParticleColoredFlame(world, x, y, z, velX, velY, velZ, 0.0f, 0.0f, 0.0f);
                    break;
                }
                case BLUE_FLAME: {
                    particle = new ParticleColoredFlame(world, x, y, z, velX, velY, velZ, 0.3f, 0.7f, 1.0f);
                    break;
                }
                case GREEN_FLAME: {
                    particle = new ParticleColoredFlame(world, x, y, z, velX, velY, velZ, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case PURPLE_FLAME: {
                    particle = new ParticleColoredFlame(world, x, y, z, velX, velY, velZ, 1.0f, 0.0f, 1.0f);
                    break;
                }
                case FROST: {
                    particle = new ParticleFrost(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case SPARKLER: {
                    particle = new ParticleSparkler(world, x, y, z, velX, velY, velZ);
                    break;
                }
                case ENDER_TRIPLET: {
                    particle = new ParticleEnderTriplet(world, x, y, z, velX, velY, velZ);
                }
            }
            if (particle != null) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
        }
    }

    @Override
    public void spawnColoredParticle(World world, double x, double y, double z, Color color, boolean bigger, boolean shortLived) {
        if (this.canSpawnParticle(world, x, y, z)) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleColored(world, x, y, z, 0.0, 0.0, 0.0, color, bigger, shortLived));
        }
    }

    private boolean canSpawnParticle(World world, double x, double y, double z) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity != null && mc.field_71452_i != null) {
            double d2;
            double d1;
            double d0;
            int i = mc.field_71474_y.field_74362_aa;
            if (i == 1 && world.field_73012_v.nextInt(3) == 0) {
                i = 2;
            }
            return (d0 = entity.field_70165_t - x) * d0 + (d1 = entity.field_70163_u - y) * d1 + (d2 = entity.field_70161_v - z) * d2 <= 1024.0 && i <= 1;
        }
        return false;
    }
}

