/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.container.gui;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GuiDivineMerchant
extends GuiContainer {
    private final IMerchant merchant;
    private MerchantButton nextButton;
    private MerchantButton previousButton;
    private int selectedMerchantRecipe;

    public GuiDivineMerchant(InventoryPlayer playerInventory, IMerchant merchant, World world) {
        super((Container)new ContainerMerchant(playerInventory, merchant, world));
        this.merchant = merchant;
    }

    abstract ResourceLocation getGuiTexture();

    abstract String getMerchantName();

    abstract int getTextColor();

    public void func_73866_w_() {
        super.func_73866_w_();
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.nextButton = (MerchantButton)this.func_189646_b(new MerchantButton(1, i + 120 + 27, j + 24 - 1, true, this.getGuiTexture()));
        this.previousButton = (MerchantButton)this.func_189646_b(new MerchantButton(2, i + 36 - 19, j + 24 - 1, false, this.getGuiTexture()));
        this.nextButton.field_146124_l = false;
        this.previousButton.field_146124_l = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.getMerchantName();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, this.getTextColor());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, this.getTextColor());
    }

    public void func_73876_c() {
        super.func_73876_c();
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null) {
            this.nextButton.field_146124_l = this.selectedMerchantRecipe < merchantrecipelist.size() - 1;
            this.previousButton.field_146124_l = this.selectedMerchantRecipe > 0;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        boolean flag = false;
        if (button == this.nextButton) {
            ++this.selectedMerchantRecipe;
            MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
            if (merchantrecipelist != null && this.selectedMerchantRecipe >= merchantrecipelist.size()) {
                this.selectedMerchantRecipe = merchantrecipelist.size() - 1;
            }
            flag = true;
        } else if (button == this.previousButton) {
            --this.selectedMerchantRecipe;
            if (this.selectedMerchantRecipe < 0) {
                this.selectedMerchantRecipe = 0;
            }
            flag = true;
        }
        if (flag) {
            ((ContainerMerchant)this.field_147002_h).func_75175_c(this.selectedMerchantRecipe);
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeInt(this.selectedMerchantRecipe);
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new CPacketCustomPayload("MC|TrSel", packetbuffer));
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiTexture());
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null && !merchantrecipelist.isEmpty()) {
            int k = this.selectedMerchantRecipe;
            if (k < 0 || k >= merchantrecipelist.size()) {
                return;
            }
            MerchantRecipe merchantrecipe = (MerchantRecipe)merchantrecipelist.get(k);
            if (merchantrecipe.func_82784_g()) {
                this.field_146297_k.func_110434_K().func_110577_a(this.getGuiTexture());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                this.func_73729_b(this.field_147003_i + 83, this.field_147009_r + 21, 212, 0, 28, 21);
                this.func_73729_b(this.field_147003_i + 83, this.field_147009_r + 51, 212, 0, 28, 21);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null && !merchantrecipelist.isEmpty()) {
            int i = (this.field_146294_l - this.field_146999_f) / 2;
            int j = (this.field_146295_m - this.field_147000_g) / 2;
            int k = this.selectedMerchantRecipe;
            MerchantRecipe merchantrecipe = (MerchantRecipe)merchantrecipelist.get(k);
            ItemStack itemstack = merchantrecipe.func_77394_a();
            ItemStack itemstack1 = merchantrecipe.func_77396_b();
            ItemStack itemstack2 = merchantrecipe.func_77397_d();
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 100.0f;
            this.field_146296_j.func_180450_b(itemstack, i + 36, j + 24);
            this.field_146296_j.func_175030_a(this.field_146289_q, itemstack, i + 36, j + 24);
            if (!itemstack1.func_190926_b()) {
                this.field_146296_j.func_180450_b(itemstack1, i + 62, j + 24);
                this.field_146296_j.func_175030_a(this.field_146289_q, itemstack1, i + 62, j + 24);
            }
            this.field_146296_j.func_180450_b(itemstack2, i + 120, j + 24);
            this.field_146296_j.func_175030_a(this.field_146289_q, itemstack2, i + 120, j + 24);
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179140_f();
            if (this.func_146978_c(36, 24, 16, 16, mouseX, mouseY) && !itemstack.func_190926_b()) {
                this.func_146285_a(itemstack, mouseX, mouseY);
            } else if (!itemstack1.func_190926_b() && this.func_146978_c(62, 24, 16, 16, mouseX, mouseY) && !itemstack1.func_190926_b()) {
                this.func_146285_a(itemstack1, mouseX, mouseY);
            } else if (!itemstack2.func_190926_b() && this.func_146978_c(120, 24, 16, 16, mouseX, mouseY) && !itemstack2.func_190926_b()) {
                this.func_146285_a(itemstack2, mouseX, mouseY);
            } else if (merchantrecipe.func_82784_g() && (this.func_146978_c(83, 21, 28, 21, mouseX, mouseY) || this.func_146978_c(83, 51, 28, 21, mouseX, mouseY))) {
                this.func_146279_a(I18n.func_135052_a((String)"merchant.deprecated", (Object[])new Object[0]), mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public IMerchant getMerchant() {
        return this.merchant;
    }

    @SideOnly(value=Side.CLIENT)
    static class MerchantButton
    extends GuiButton {
        private final boolean forward;
        ResourceLocation res;

        public MerchantButton(int buttonID, int x, int y, boolean forward, ResourceLocation res) {
            super(buttonID, x, y, 12, 19, "");
            this.forward = forward;
            this.res = res;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(this.res);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = 0;
                int j = 176;
                if (!this.field_146124_l) {
                    j += this.field_146120_f * 2;
                } else if (flag) {
                    j += this.field_146120_f;
                }
                if (!this.forward) {
                    i += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, j, i, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

