/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.entity;

import com.google.common.collect.Sets;
import divinerpg.api.armor.ArmorEquippedEvent;
import divinerpg.api.armor.IItemContainer;
import divinerpg.objects.blocks.tile.container.KingCompressorContainer;
import divinerpg.objects.blocks.tile.entity.base.IFuelProvider;
import divinerpg.objects.blocks.tile.entity.base.ModUpdatableTileEntity;
import divinerpg.registry.ItemRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityKingCompressior
extends ModUpdatableTileEntity
implements ITickable,
IInteractionObject,
IFuelProvider {
    private final ResourceLocation id = new ResourceLocation("divinerpg", "king_compressor");
    private final NonNullList<ItemStack> container;
    private final int kingCreationLimit;
    private final int maxAbsorbedCount;
    private final Set<String> absorbedSets = new HashSet<String>();
    public boolean keepInventory = false;
    private int burningTime = 0;
    private int cookTime = 0;

    public TileEntityKingCompressior() {
        this.kingCreationLimit = -1;
        this.maxAbsorbedCount = -1;
        this.container = NonNullList.func_191197_a((int)(EntityEquipmentSlot.values().length * 2 + 1), (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        this.updateBurningTick();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new KingCompressorContainer(playerInventory, this);
    }

    public String func_174875_k() {
        return this.id.toString();
    }

    public String func_70005_c_() {
        return String.format("tile.%s.name", this.id.func_110623_a());
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean needFuel() {
        return true;
    }

    @Override
    public int consumeFuel() {
        for (int i = EntityEquipmentSlot.values().length * 2; i < this.func_70302_i_(); ++i) {
            int time = this.getBurnTime(this.func_70301_a(i));
            if (time <= 0) continue;
            this.func_70298_a(i, 1);
            return time;
        }
        return 0;
    }

    @Override
    public void onFinished() {
        if (!this.field_145850_b.field_72995_K) {
            this.onFinish(this.getPossibleOperation());
        }
        this.func_70296_d();
    }

    private void onFinish(OperationTypes operation) {
        if (operation == null) {
            return;
        }
        EntityEquipmentSlot[] values = EntityEquipmentSlot.values();
        switch (operation) {
            case Absorning: {
                EntityEquipmentSlot[] slots;
                Set<ResourceLocation> names = this.getCurrentSetPowerNames();
                this.absorbedSets.addAll(names.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
                for (EntityEquipmentSlot id : slots = values) {
                    this.func_70299_a(id.func_188452_c() + slots.length, ItemStack.field_190927_a);
                }
                break;
            }
            case KingSetCreation: {
                this.absorbedSets.clear();
                break;
            }
            case Infusion: {
                for (EntityEquipmentSlot id : values) {
                    int outputIndex = id.func_188452_c();
                    int input = outputIndex + values.length;
                    ItemStack toAbsorb = this.func_70301_a(input);
                    if (toAbsorb.func_190926_b()) continue;
                    ItemStack stack = this.func_70301_a(outputIndex);
                    if (stack.func_77973_b() instanceof IItemContainer) {
                        ((IItemContainer)stack.func_77973_b()).absorb(stack, toAbsorb);
                    }
                    this.func_70299_a(input, ItemStack.field_190927_a);
                }
                break;
            }
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public boolean haveItemsToSmelt() {
        OperationTypes types = this.getPossibleOperation();
        if (types == null) {
            return false;
        }
        switch (types) {
            case KingSetCreation: {
                return true;
            }
            case Infusion: {
                for (ItemStack stack : Arrays.stream(EntityEquipmentSlot.values()).map(x -> this.func_70301_a(x.func_188452_c())).filter(x -> !x.func_190926_b() && x.func_77973_b() instanceof IItemContainer).collect(Collectors.toList())) {
                    if (((IItemContainer)stack.func_77973_b()).getAbsorbedItemStacks(stack).size() < this.maxAbsorbedCount) continue;
                    return false;
                }
            }
            case Absorning: {
                return this.getCurrentSetPowerNames().stream().anyMatch(x -> !this.absorbedSets.contains(x.toString()));
            }
        }
        return false;
    }

    @Override
    public int getBurningTicks() {
        return this.burningTime;
    }

    @Override
    public void setBurningTicks(int value) {
        this.burningTime = value;
    }

    @Override
    public int getCurrentCookTime() {
        return this.cookTime;
    }

    @Override
    public void setCookTime(int value) {
        this.cookTime = value;
    }

    @Override
    public int getCookTimeLength() {
        return 600;
    }

    @Override
    public void changeBurnState(boolean isBurning) {
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
        this.keepInventory = true;
        this.keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryRef() {
        return this.container;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.field_70170_p.func_175625_s(this.field_174879_c) == this && player.func_174818_b(this.field_174879_c) < 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        EntityEquipmentSlot[] values = EntityEquipmentSlot.values();
        if (index == values.length * 2) {
            return this.needFuel() && this.getBurnTime(stack) > 0;
        }
        if (0 <= index && index < values.length) {
            return stack.func_77973_b() instanceof IItemContainer;
        }
        if (values.length <= index && index < values.length * 2) {
            return this.getPossibleOperation() != OperationTypes.KingSetCreation;
        }
        return index > values.length + 1;
    }

    @Nullable
    public OperationTypes getPossibleOperation() {
        boolean anyInputSlot = false;
        boolean anyOutputSlot = false;
        int end = EntityEquipmentSlot.values().length;
        for (int i = 0; i < end; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) {
                anyOutputSlot = true;
            }
            if (this.func_70301_a(i + end).func_190926_b()) continue;
            anyInputSlot = true;
        }
        if (!anyOutputSlot && anyInputSlot) {
            return OperationTypes.Absorning;
        }
        if (!anyOutputSlot && this.absorbedSets.size() >= this.getKingCreationLimit()) {
            return OperationTypes.KingSetCreation;
        }
        if (anyOutputSlot && anyInputSlot) {
            return OperationTypes.Infusion;
        }
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound result = super.func_189515_b(compound);
        result.func_74782_a("content", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.getInventoryRef()));
        result.func_74768_a("burn", this.getBurningTicks());
        result.func_74768_a("cook", this.getCurrentCookTime());
        NBTTagList sets = new NBTTagList();
        this.absorbedSets.forEach(x -> sets.func_74742_a((NBTBase)new NBTTagString(x)));
        result.func_74782_a("absorbed", (NBTBase)sets);
        return result;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound.func_74775_l("content"), this.getInventoryRef());
        this.setBurningTicks(compound.func_74762_e("burn"));
        this.setCookTime(compound.func_74762_e("cook"));
        this.absorbedSets.clear();
        NBTBase raw = compound.func_74781_a("absorbed");
        if (raw instanceof NBTTagList) {
            ((NBTTagList)raw).forEach(x -> {
                if (x instanceof NBTTagString) {
                    this.absorbedSets.add(((NBTTagString)x).func_150285_a_());
                }
            });
        }
    }

    private Set<ResourceLocation> getCurrentSetPowerNames() {
        EntityEquipmentSlot[] slots;
        HashMap<EntityEquipmentSlot, ItemStack> input = new HashMap<EntityEquipmentSlot, ItemStack>();
        for (EntityEquipmentSlot id : slots = EntityEquipmentSlot.values()) {
            input.put(id, this.func_70301_a(id.func_188452_c() + slots.length));
        }
        if (input.values().stream().allMatch(ItemStack::func_190926_b)) {
            return Sets.newHashSet();
        }
        ArmorEquippedEvent event = new ArmorEquippedEvent(input);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getConfirmed();
    }

    public int getBurnTime(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() == ItemRegistry.shadowStone) {
            return this.getCookTimeLength() / 2;
        }
        return 0;
    }

    public Set<String> getAbsorbedSets() {
        return this.absorbedSets;
    }

    public int getKingCreationLimit() {
        return this.kingCreationLimit;
    }

    public static enum OperationTypes {
        Absorning,
        KingSetCreation,
        Infusion;

    }
}

