/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.container;

import divinerpg.objects.blocks.tile.entity.TileEntityKingCompressior;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KingCompressorContainer
extends Container {
    private final InventoryPlayer inventoryPlayer;
    private final TileEntityKingCompressior tile;
    private final int lastInvIndex;

    public KingCompressorContainer(InventoryPlayer inventoryPlayer, final TileEntityKingCompressior tile) {
        EntityEquipmentSlot slot;
        int i;
        EntityEquipmentSlot slot2;
        int i2;
        this.inventoryPlayer = inventoryPlayer;
        this.tile = tile;
        List<EntityEquipmentSlot> armorSlots = Arrays.asList(EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET);
        List<EntityEquipmentSlot> handSlots = Arrays.asList(EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND);
        int baseOffset = 8;
        for (i2 = 0; i2 < armorSlots.size(); ++i2) {
            slot2 = armorSlots.get(i2);
            this.func_75146_a(new Slot(tile, armorSlots.get(i2).func_188452_c(), 152, baseOffset + i2 * 18){

                public boolean func_75214_a(ItemStack stack) {
                    return EntityLiving.func_184640_d((ItemStack)stack) == slot2 && tile.func_94041_b(this.getSlotIndex(), stack);
                }

                public int func_75219_a() {
                    return 1;
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[slot2.func_188454_b()];
                }
            });
        }
        for (i2 = 0; i2 < handSlots.size(); ++i2) {
            slot2 = handSlots.get(i2);
            this.func_75146_a(new Slot(tile, handSlots.get(i2).func_188452_c(), 134 + i2 * 18, 85){

                public boolean func_75214_a(ItemStack stack) {
                    return EntityLiving.func_184640_d((ItemStack)stack) == slot2 && tile.func_94041_b(this.getSlotIndex(), stack);
                }

                public int func_75219_a() {
                    return 1;
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    if (slot2 == EntityEquipmentSlot.OFFHAND) {
                        return "minecraft:items/empty_armor_slot_shield";
                    }
                    return super.func_178171_c();
                }
            });
        }
        int startIndex = armorSlots.size() + handSlots.size();
        for (i = 0; i < armorSlots.size(); ++i) {
            slot = armorSlots.get(i);
            this.func_75146_a(new Slot(tile, armorSlots.get(i).func_188452_c() + startIndex, baseOffset, baseOffset + i * 18){

                public boolean func_75214_a(ItemStack stack) {
                    return EntityLiving.func_184640_d((ItemStack)stack) == slot && tile.func_94041_b(this.getSlotIndex(), stack);
                }

                public int func_75219_a() {
                    return 1;
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[slot.func_188454_b()];
                }
            });
        }
        for (i = 0; i < handSlots.size(); ++i) {
            slot = handSlots.get(i);
            this.func_75146_a(new Slot(tile, handSlots.get(i).func_188452_c() + startIndex, baseOffset + i * 18, 85){

                public boolean func_75214_a(ItemStack stack) {
                    return EntityLiving.func_184640_d((ItemStack)stack) == slot && tile.func_94041_b(this.getSlotIndex(), stack);
                }

                public int func_75219_a() {
                    return 1;
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    if (slot == EntityEquipmentSlot.OFFHAND) {
                        return "minecraft:items/empty_armor_slot_shield";
                    }
                    return super.func_178171_c();
                }
            });
        }
        this.lastInvIndex = startIndex * 2;
        this.func_75146_a(new Slot(tile, this.lastInvIndex, 80, 85){

            public boolean func_75214_a(ItemStack stack) {
                return tile.getBurnTime(stack) > 0;
            }
        });
        this.bindPlayerInventory(baseOffset, 111);
    }

    private void bindPlayerInventory(int topX, int topY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, j + i * 9 + 9, topX + j * 18, topY));
            }
            topY += 18;
        }
        topY += 4;
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, k, topX + k * 18, topY));
        }
    }

    public int getCookTimePercentage() {
        int cookTime = this.tile.func_174887_a_(1);
        if (cookTime == 0) {
            return 0;
        }
        double value = (double)cookTime * 1.0 / (double)this.tile.getCookTimeLength();
        int precantages = (int)Math.ceil(value * 100.0);
        return MathHelper.func_76125_a((int)precantages, (int)0, (int)100);
    }

    public Set<String> getAbsorbedSets() {
        return this.tile.getAbsorbedSets();
    }

    public int getLimit() {
        return this.tile.getKingCreationLimit();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_175173_a((Container)this, (IInventory)this.tile);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemStack = itemStack1.func_77946_l();
            if (index < this.lastInvIndex ? !this.func_75135_a(itemStack1, this.lastInvIndex + 1, this.field_75151_b.size() - 1, true) : !this.func_75135_a(itemStack1, 0, this.lastInvIndex, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.func_70300_a(playerIn);
    }
}

