/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.iceika;

import divinerpg.dimensions.iceika.IceTreeGen;
import divinerpg.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeIceika
extends Biome {
    private static Biome.BiomeProperties properties = new Biome.BiomeProperties("Iceika").func_185410_a(0.0f).func_185395_b(0.5f).func_185411_b().func_185400_d(0.5f);
    WorldGenTallGrass tallGrass = new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    WorldGenerator genIceTree = new IceTreeGen(false, false);

    public BiomeIceika() {
        super(properties);
        this.setRegistryName("divinerpg", "iceika");
        this.field_76752_A = BlockRegistry.frozenGrass.func_176223_P();
        this.field_76753_B = BlockRegistry.frozenDirt.func_176223_P();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.flowers.clear();
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76803_B = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float par1) {
        return 100;
    }

    public boolean func_76746_c() {
        return true;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return 3734015;
    }

    public int getModdedBiomeGrassColor(int original) {
        return 3734015;
    }

    public boolean func_76738_d() {
        return false;
    }

    public Biome.TempCategory func_150561_m() {
        return Biome.TempCategory.COLD;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateIceikaTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int currentX = pos.func_177958_n();
        int currentZ = pos.func_177952_p();
        for (int k = 0; k < rand.nextInt(3); ++k) {
            int x = currentX + rand.nextInt(8) + 8;
            int z = currentZ + rand.nextInt(8) + 8;
            int y = worldIn.func_189649_b(x, z);
            BlockPos treePos = new BlockPos(x, y, z);
            this.genIceTree.func_180709_b(worldIn, rand, treePos);
        }
    }

    protected void generateIceikaTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int seaLevel = worldIn.func_181545_F();
        IBlockState topBlock = this.field_76752_A;
        IBlockState fillerBlock = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int currentY = 255; currentY >= 0; --currentY) {
            if (currentY <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(chunkZ, currentY, chunkX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(chunkZ, currentY, chunkX);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != BlockRegistry.frozenStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    topBlock = field_185366_b;
                    fillerBlock = field_185365_a;
                } else if (currentY >= seaLevel - 4 && currentY <= seaLevel + 1) {
                    topBlock = BlockRegistry.frozenGrass.func_176223_P();
                    fillerBlock = BlockRegistry.frozenDirt.func_176223_P();
                }
                if (currentY < seaLevel && (topBlock == null || topBlock.func_185904_a() == Material.field_151579_a)) {
                    topBlock = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, currentY, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (currentY >= seaLevel - 1) {
                    chunkPrimerIn.func_177855_a(chunkZ, currentY, chunkX, topBlock);
                    continue;
                }
                if (currentY < seaLevel - 7 - k) {
                    topBlock = field_185366_b;
                    fillerBlock = BlockRegistry.frozenStone.func_176223_P();
                    continue;
                }
                chunkPrimerIn.func_177855_a(chunkZ, currentY, chunkX, fillerBlock);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(chunkZ, currentY, chunkX, fillerBlock);
            if (--j != 0 || fillerBlock.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, currentY - 63);
            fillerBlock = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
        }
    }
}

