/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="divinerpg")
@Config(modid="divinerpg", name="divinerpg/general_config")
public class GeneralConfig {
    @Config.Name(value="General Options")
    @Config.Comment(value={"Configure general settings here"})
    public static GeneralOptions generalOptions = new GeneralOptions();
    @Config.Name(value="Dimension IDs")
    @Config.Comment(value={"Configure DivineRPG dimension IDs here. Don't change these unless you know what you're doing"})
    @Config.RequiresMcRestart
    public static DimensionIDs dimensionIDs = new DimensionIDs();
    @Config.Name(value="GUI Options")
    @Config.Comment(value={"Configure GUI settings here"})
    public static GUIOptions guiOptions = new GUIOptions();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("divinerpg")) {
            ConfigManager.sync((String)"divinerpg", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class GUIOptions {
        @Config.Name(value="ArcanaX")
        @Config.RangeInt(min=1, max=255)
        public int arcanaX = 111;
        @Config.Name(value="ArcanaY")
        @Config.RangeInt(min=1, max=255)
        public int arcanaY = 18;
        @Config.Name(value="HideArcanaBar")
        @Config.Comment(value={"Don't render arcana bar if full"})
        public boolean hideArcanaBar = true;
    }

    public static class DimensionIDs {
        @Config.Name(value="Eden")
        public int edenDimensionID = 420;
        @Config.Name(value="Wildwood")
        public int wildwoodDimensionID = 421;
        @Config.Name(value="Apalachia")
        public int apalachiaDimensionID = 422;
        @Config.Name(value="Skythern")
        public int skythernDimensionID = 423;
        @Config.Name(value="Mortum")
        public int mortumDimensionID = 424;
        @Config.Name(value="Iceika")
        public int iceikaDimensionID = 425;
        @Config.Name(value="Arcana")
        public int arcanaDimensionID = 426;
        @Config.Name(value="Vethea")
        public int vetheaDimensionID = 427;
    }

    public static class GeneralOptions {
        @Config.Name(value="Debug mode")
        @Config.Comment(value={"Prints a bunch of extra, mostly unvetted information. Keep this disabled unless instructed"})
        public boolean enableDebugMode = false;
        @Config.Name(value="Enable player hats")
        @Config.Comment(value={"Set to false to disable player hats for special players"})
        public boolean enablePlayerHats = true;
        @Config.Name(value="Enable welcome messages")
        @Config.Comment(value={"Set to false to disable the welcome messages for special players"})
        public boolean enableWelcomeMessages = true;
    }
}

