/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;

public abstract class WorldGeneratorTree
extends WorldGenerator {
    public WorldGeneratorTree(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos blockPos) {
        int x = blockPos.func_177958_n();
        int retries = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int c = 0; c < retries; ++c) {
            int y;
            BlockPos loopPos = new BlockPos(x, y, z);
            for (y = world.func_72940_L() - 1; world.func_175623_d(loopPos) && y > 0; --y) {
            }
            if (!this.growTree(world, rand, loopPos.func_177982_a(0, 1, 0))) {
                --retries;
            }
            x += rand.nextInt(16) - 8;
            z += rand.nextInt(16) - 8;
        }
        return true;
    }

    protected abstract int baseHeight();

    protected abstract int baseHeightRandomRange();

    public abstract BlockLeaves getLeaves();

    public abstract BlockLog getLogs();

    public abstract BlockSapling getSapling();

    public boolean growTree(World world, Random rand, BlockPos blockPos) {
        int treeHeight = rand.nextInt(this.baseHeightRandomRange()) + this.baseHeight();
        int worldHeight = world.func_72800_K();
        if (blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() + treeHeight + 1 <= worldHeight) {
            BlockPos basePos = blockPos.func_177982_a(0, -1, 0);
            IBlockState blockState = world.func_180495_p(basePos);
            Block block = blockState.func_177230_c();
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            if (block != null && block.canSustainPlant(blockState, (IBlockAccess)world, basePos, EnumFacing.UP, (IPlantable)this.getSapling()) && y < worldHeight - treeHeight - 1) {
                int zOffset;
                int xOffset;
                int yOffset;
                for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                    int radius = 1;
                    if (yOffset == y) {
                        radius = 0;
                    }
                    if (yOffset >= y + 1 + treeHeight - 3) {
                        radius = 3;
                    }
                    if (yOffset >= 0 & yOffset < worldHeight) {
                        for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                            for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                BlockPos loopPos = new BlockPos(xOffset, yOffset, zOffset);
                                IBlockState loopBlockState = world.func_180495_p(loopPos);
                                block = loopBlockState.func_177230_c();
                                if (block == null || block.isLeaves(loopBlockState, (IBlockAccess)world, loopPos) || block == Blocks.field_150350_a || block.canBeReplacedByLeaves(loopBlockState, (IBlockAccess)world, loopPos)) continue;
                                return false;
                            }
                        }
                        continue;
                    }
                    return false;
                }
                if (block != null) {
                    block.onPlantGrow(blockState, world, basePos, blockPos);
                    for (yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                        int var12 = yOffset - (y + treeHeight);
                        int center = 1 - var12 / 2;
                        for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                            int xPos = xOffset - x;
                            int t = xPos >> 31;
                            xPos = xPos + t ^ t;
                            for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                                int zPos = zOffset - z;
                                t = zPos >> 31;
                                zPos = zPos + t ^ t;
                                BlockPos loopPos = new BlockPos(xOffset, yOffset, zOffset);
                                IBlockState loopBlockState = world.func_180495_p(loopPos);
                                block = loopBlockState.func_177230_c();
                                if (!(xPos != center | zPos != center) && (rand.nextInt(2) == 0 || var12 == 0) || block != null && !block.isLeaves(loopBlockState, (IBlockAccess)world, loopPos) && block != Blocks.field_150350_a && !block.canBeReplacedByLeaves(loopBlockState, (IBlockAccess)world, loopPos)) continue;
                                this.func_175903_a(world, loopPos, this.getLeaves().func_176223_P());
                            }
                        }
                    }
                    for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                        BlockPos loopPos = blockPos.func_177982_a(0, yOffset, 0);
                        IBlockState loopBlockState = world.func_180495_p(loopPos);
                        block = loopBlockState.func_177230_c();
                        if (block != null && block != Blocks.field_150350_a && !block.isLeaves(loopBlockState, (IBlockAccess)world, loopPos) && !block.func_176200_f((IBlockAccess)world, loopPos)) continue;
                        this.func_175903_a(world, loopPos, this.getLogs().func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

