/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLike;

public interface IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L extends IIngredientCollectionLike<T, M, I>>
extends IIngredientCollectionLike<T, M, I> {
    public IngredientComponentCategoryType<T, M, C> getCategoryType();

    default public boolean appliesToClassifier(M matchCondition) {
        return this.getComponent().getMatcher().hasCondition(matchCondition, this.getCategoryType().getMatchCondition());
    }

    default public C getClassifier(T instance) {
        return (C)this.getCategoryType().getClassifier().apply(instance);
    }

    public L createEmptyCollection();

    default public L getOrCreateClassifiedCollection(C classifier) {
        return (L)this.getClassifiedCollections().computeIfAbsent(classifier, k -> this.createEmptyCollection());
    }

    public T getInstance(I var1);

    public Map<C, L> getClassifiedCollections();

    public void setSize(int var1);

    public static class ClassifiedIteratorDelegated<T, M, C, I, L extends IIngredientCollectionLike<T, M, I>>
    implements Iterator<I> {
        private final IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection;
        private final Iterator<I> iterator;
        private I lastInstance;

        public ClassifiedIteratorDelegated(IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection, L collection, T instance, M matchCondition) {
            if (Objects.equals(classifiedCollection.getCategoryType().getMatchCondition(), matchCondition)) {
                this.iterator = collection.iterator();
            } else {
                Object subMatchCondition = classifiedCollection.getComponent().getMatcher().withoutCondition(matchCondition, classifiedCollection.getCategoryType().getMatchCondition());
                this.iterator = collection.iterator(instance, (Object)subMatchCondition);
            }
            this.classifiedCollection = classifiedCollection;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public I next() {
            this.lastInstance = this.iterator.next();
            return this.lastInstance;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            this.classifiedCollection.setSize(this.classifiedCollection.size() - 1);
            C classifier = this.classifiedCollection.getClassifier(this.classifiedCollection.getInstance(this.lastInstance));
            if (((IIngredientCollectionLike)this.classifiedCollection.getClassifiedCollections().get(classifier)).isEmpty()) {
                this.classifiedCollection.getClassifiedCollections().remove(classifier);
            }
        }
    }

    public static class ClassifiedIterator<T, M, I, C, L extends IIngredientCollectionLike<T, M, I>>
    implements Iterator<I> {
        private final IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection;
        private Iterator<Map.Entry<C, L>> classifierIterator;
        private Iterator<I> instanceIterator;
        private Map.Entry<C, L> lastClassifierEntry;

        public ClassifiedIterator(IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection) {
            this.classifiedCollection = classifiedCollection;
            this.classifierIterator = this.classifiedCollection.getClassifiedCollections().entrySet().iterator();
            this.instanceIterator = null;
        }

        protected void prepareNextIterators() {
            if ((this.instanceIterator == null || !this.instanceIterator.hasNext()) && this.classifierIterator.hasNext()) {
                this.lastClassifierEntry = this.classifierIterator.next();
                this.instanceIterator = ((IIngredientCollectionLike)this.classifiedCollection.getClassifiedCollections().get(this.lastClassifierEntry.getKey())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.prepareNextIterators();
            return this.instanceIterator != null && this.instanceIterator.hasNext();
        }

        @Override
        public I next() {
            this.prepareNextIterators();
            if (this.instanceIterator == null) {
                throw new NoSuchElementException("No next instances are available");
            }
            return this.instanceIterator.next();
        }

        @Override
        public void remove() {
            if (this.instanceIterator == null) {
                throw new IllegalStateException("The next method was not called yet");
            }
            this.instanceIterator.remove();
            this.classifiedCollection.setSize(this.classifiedCollection.size() - 1);
            if (((IIngredientCollectionLike)this.classifiedCollection.getClassifiedCollections().get(this.lastClassifierEntry.getKey())).isEmpty()) {
                this.classifierIterator.remove();
            }
        }
    }
}

