/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class TileHelpers {
    public static <T> T getSafeTile(DimPos dimPos, Class<T> targetClazz) {
        World world = dimPos.getWorld();
        if (world == null) {
            return null;
        }
        return TileHelpers.getSafeTile((IBlockAccess)world, dimPos.getBlockPos(), targetClazz);
    }

    public static <T> T getSafeTile(IBlockAccess world, BlockPos pos, Class<T> targetClazz) {
        TileEntity tile = world.func_175625_s(pos);
        try {
            return targetClazz.cast(tile);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <C> C getCapability(DimPos dimPos, Capability<C> capability) {
        World world = dimPos.getWorld();
        if (world == null) {
            return null;
        }
        return TileHelpers.getCapability(world, dimPos.getBlockPos(), null, capability);
    }

    public static <C> C getCapability(DimPos dimPos, EnumFacing side, Capability<C> capability) {
        World world = dimPos.getWorld();
        if (world == null) {
            return null;
        }
        return TileHelpers.getCapability(world, dimPos.getBlockPos(), side, capability);
    }

    public static <C> C getCapability(World world, BlockPos pos, EnumFacing side, Capability<C> capability) {
        return TileHelpers.getCapability((IBlockAccess)world, pos, side, capability);
    }

    public static <C> C getCapability(IBlockAccess world, BlockPos pos, Capability<C> capability) {
        return TileHelpers.getCapability(world, pos, null, capability);
    }

    public static <C> C getCapability(IBlockAccess world, BlockPos pos, EnumFacing side, Capability<C> capability) {
        TileEntity tile = TileHelpers.getSafeTile(world, pos, TileEntity.class);
        if (tile != null) {
            return (C)tile.getCapability(capability, side);
        }
        return null;
    }
}

