/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.client.model.ConnectedBlockModel;
import org.cyclops.cyclopscore.client.model.DirectionCorner;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ConfigurableBlockConnectedTexture
extends ConfigurableBlock {
    @BlockProperty
    public static final IUnlistedProperty<Boolean>[] CONNECTED = new IUnlistedProperty[6];
    @BlockProperty
    public static final IUnlistedProperty<Boolean>[] CONNECTED_CORNER = new IUnlistedProperty[DirectionCorner.values().length];
    @SideOnly(value=Side.CLIENT)
    private Map<String, ResourceLocation> textureMap;
    @SideOnly(value=Side.CLIENT)
    private Map<String, TextureAtlasSprite> loadedTextureMap;

    public ConfigurableBlockConnectedTexture(ExtendedConfig<BlockConfig> eConfig, Material material) {
        super(eConfig, material);
        if (MinecraftHelpers.isClientSide()) {
            this.textureMap = Maps.newHashMap();
            this.loadedTextureMap = Maps.newHashMap();
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.loadTextureMap();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void loadTextureMap() {
        String mod = this.getConfig().getMod().getModId();
        String base = "blocks/" + this.getConfig().getNamedId();
        this.textureMap.put("background", new ResourceLocation(mod, base));
        this.textureMap.put("border", new ResourceLocation(mod, base + "_border"));
        this.textureMap.put("corner", new ResourceLocation(mod, base + "_corner"));
        this.textureMap.put("inner_corner", new ResourceLocation(mod, base + "_inner_corner"));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(String name) {
        return this.loadedTextureMap.get(name);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        for (Map.Entry<String, ResourceLocation> textureEntry : this.textureMap.entrySet()) {
            this.loadedTextureMap.put(textureEntry.getKey(), event.getMap().func_174942_a(textureEntry.getValue()));
        }
    }

    protected boolean isConnected(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this;
    }

    protected boolean isConnected(IBlockAccess world, BlockPos pos, DirectionCorner corner) {
        return world.func_180495_p(corner.fromOffset(pos)).func_177230_c() == this;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)this.func_176223_P();
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            extendedState = extendedState.withProperty(CONNECTED[enumFacing.ordinal()], (Object)this.isConnected(world, pos, enumFacing));
        }
        for (DirectionCorner directionCorner : DirectionCorner.values()) {
            extendedState = extendedState.withProperty(CONNECTED_CORNER[directionCorner.ordinal()], (Object)this.isConnected(world, pos, directionCorner));
        }
        return extendedState;
    }

    @Override
    public boolean hasDynamicModel() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new ConnectedBlockModel(this);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    static {
        for (EnumFacing enumFacing : EnumFacing.values()) {
            ConfigurableBlockConnectedTexture.CONNECTED[enumFacing.ordinal()] = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)("connect-" + enumFacing.func_176610_l())));
        }
        for (DirectionCorner directionCorner : DirectionCorner.values()) {
            ConfigurableBlockConnectedTexture.CONNECTED_CORNER[directionCorner.ordinal()] = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)("connect_corner-" + directionCorner.name())));
        }
    }
}

