/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class GuiNumberField
extends GuiTextFieldExtended {
    private final boolean arrows;
    private GuiButtonArrow arrowUp;
    private GuiButtonArrow arrowDown;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    public GuiNumberField(int componentId, FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, boolean background) {
        super(componentId, fontrenderer, x, y, width, height, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new GuiButtonArrow(0, x, y + height / 2, GuiButtonArrow.Direction.NORTH);
            this.arrowDown = new GuiButtonArrow(1, x, y + height / 2, GuiButtonArrow.Direction.SOUTH);
            this.arrowUp.field_146129_i -= this.arrowUp.field_146121_g;
        }
        this.func_146185_a(true);
        this.func_146180_a("0");
    }

    public void func_146184_c(boolean enabled) {
        this.arrowUp.field_146124_l = enabled;
        this.arrowDown.field_146124_l = enabled;
        this.isEnabled = enabled;
        super.func_146184_c(enabled);
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.setMinValue(positiveOnly ? 0 : Integer.MIN_VALUE);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInt() throws NumberFormatException {
        return this.validateNumber(Integer.parseInt(this.func_146179_b()));
    }

    public double getDouble() throws NumberFormatException {
        return this.validateNumber(Double.parseDouble(this.func_146179_b()));
    }

    public float getFloat() throws NumberFormatException {
        return this.validateNumber(Float.parseFloat(this.func_146179_b()));
    }

    @Override
    public void drawTextBox(Minecraft minecraft, int mouseX, int mouseY) {
        int offsetX = 0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.arrows) {
            this.arrowUp.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
            this.arrowDown.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
            offsetX = this.arrowUp.field_146120_f;
            this.field_146209_f += offsetX;
            this.field_146218_h -= offsetX;
        }
        super.drawTextBox(minecraft, mouseX, mouseY);
        if (this.arrows) {
            this.field_146209_f -= offsetX;
            this.field_146218_h += offsetX;
        }
    }

    public int validateNumber(int number) {
        return Math.max(this.minValue, Math.min(this.maxValue, number));
    }

    public double validateNumber(double number) {
        return Math.max((double)this.minValue, Math.min((double)this.maxValue, number));
    }

    public float validateNumber(float number) {
        return Math.max((float)this.minValue, Math.min((float)this.maxValue, number));
    }

    protected int getDiffAmount() {
        return MinecraftHelpers.isShifted() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
    }

    protected void decrease() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
    }

    @Override
    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (this.isEnabled) {
            boolean ret = true;
            if (this.arrows && this.arrowUp.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
                this.increase();
            } else if (this.arrows && this.arrowDown.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
                this.decrease();
            } else {
                ret = super.func_146192_a(mouseX, mouseY, mouseButton);
            }
            this.updateArrowsState();
            return ret;
        }
        return false;
    }

    @Override
    public void func_146180_a(String value) {
        super.func_146180_a(value);
        this.updateArrowsState();
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        boolean ret = super.func_146201_a(typedChar, keyCode);
        this.updateArrowsState();
        return ret;
    }

    protected void updateArrowsState() {
        if (this.arrows) {
            this.arrowDown.field_146124_l = true;
            this.arrowUp.field_146124_l = true;
            try {
                if (this.getInt() <= this.minValue) {
                    this.arrowDown.field_146124_l = false;
                }
                if (this.getInt() >= this.maxValue) {
                    this.arrowUp.field_146124_l = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

