/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.misc;

import java.util.Iterator;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;

@AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="inheritProperties")
public class ScriptCommandInheritProperties
extends ScriptCommand {
    private final BiomePackage pack;
    private final BiomePackage toInheritFrom;
    private final String[] properties;

    public ScriptCommandInheritProperties(BiomePackage pack, BiomePackage toInheritFrom) {
        this(pack, toInheritFrom, null);
    }

    @Override
    public void perform() throws Exception {
        Iterator<Biome> it = this.pack.getIterator();
        while (it.hasNext()) {
            String[] props;
            Biome gen = it.next();
            if (this.properties == null) {
                props = BiomePropertyManager.getAllNames().toArray(new String[0]);
            } else {
                props = this.properties;
                for (int i = 0; i < props.length; ++i) {
                    props[i] = props[i].toLowerCase();
                }
            }
            for (String property : props) {
                Property<?> prop = BiomePropertyManager.findProperty(property);
                if (prop == null) {
                    LogHelper.error("No property found for " + property);
                    continue;
                }
                if (!prop.isCopyable()) {
                    if (this.properties == null) continue;
                    LogHelper.error("Property " + property + " is not copyable!");
                    continue;
                }
                Iterator<Biome> inheritFrom = this.toInheritFrom.getIterator();
                while (inheritFrom.hasNext()) {
                    try {
                        prop.copy(inheritFrom.next(), gen);
                    }
                    catch (Exception e) {
                        LogHelper.debug("Failed to inherit property " + property + ". This may be because it hasn't been set in the parent biome, or the property is not readable.");
                    }
                }
            }
        }
    }

    public ScriptCommandInheritProperties(BiomePackage pack, BiomePackage toInheritFrom, String[] properties) {
        this.pack = pack;
        this.toInheritFrom = toInheritFrom;
        this.properties = properties;
    }
}

