/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import me.superckl.biometweaker.common.world.gen.BlockReplacementManager;
import me.superckl.biometweaker.common.world.gen.ReplacementConstraints;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class BlockReplacementEntry {
    private final Block block;
    private final TIntObjectMap<List<BlockReplacementManager.WeightedBlockEntry>> replacements = new TIntObjectHashMap();

    public BlockReplacementEntry(Block toReplace) {
        this.block = toReplace;
    }

    @Nullable
    public List<BlockReplacementManager.WeightedBlockEntry> findEntriesForMeta(int meta) {
        if (this.replacements.containsKey(-1)) {
            ArrayList<BlockReplacementManager.WeightedBlockEntry> entries = new ArrayList<BlockReplacementManager.WeightedBlockEntry>((Collection)this.replacements.get(-1));
            if (this.replacements.containsKey(meta)) {
                entries.addAll((Collection)this.replacements.get(meta));
            }
            return entries;
        }
        return (List)this.replacements.get(meta);
    }

    public void registerReplacement(int weight, IBlockState toReplace, ReplacementConstraints replacement) {
        int meta;
        if (replacement.isIgnoreMeta()) {
            if (!this.replacements.containsKey(-1)) {
                this.replacements.put(-1, (Object)Lists.newArrayList((Object[])new BlockReplacementManager.WeightedBlockEntry[]{new BlockReplacementManager.WeightedBlockEntry(weight, replacement)}));
                return;
            }
            ((List)this.replacements.get(-1)).add(new BlockReplacementManager.WeightedBlockEntry(weight, replacement));
        }
        if (!this.replacements.containsKey(meta = toReplace.func_177230_c().func_176201_c(toReplace))) {
            this.replacements.put(meta, (Object)Lists.newArrayList((Object[])new BlockReplacementManager.WeightedBlockEntry[]{new BlockReplacementManager.WeightedBlockEntry(weight, replacement)}));
            return;
        }
        ((List)this.replacements.get(meta)).add(new BlockReplacementManager.WeightedBlockEntry(weight, replacement));
    }

    public boolean matches(IBlockState toReplace) {
        return this.block == toReplace.func_177230_c() && (this.replacements.containsKey(-1) || this.replacements.containsKey(toReplace.func_177230_c().func_176201_c(toReplace)));
    }

    public boolean matches(Block toReplace) {
        return this.block == toReplace;
    }
}

