/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.biome.property;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.superckl.api.biometweaker.APIInfo;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.biometweaker.util.BiomeHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public class PropertyGenWeight
extends Property<Integer> {
    private static Set<BiomeManager.BiomeType> logged = EnumSet.noneOf(BiomeManager.BiomeType.class);

    public PropertyGenWeight() {
        super(Integer.class);
    }

    @Override
    public void set(Object obj, Integer val) throws IllegalStateException, IllegalArgumentException {
        if (!(obj instanceof Biome)) {
            throw new IllegalArgumentException("Passed object is not an instance of Biome!");
        }
        int weight = val;
        int id = Biome.func_185362_a((Biome)((Biome)obj));
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            for (BiomeManager.BiomeEntry entry : entries) {
                if (Biome.func_185362_a((Biome)entry.biome) != id) continue;
                entry.field_76292_a = weight;
            }
            if (type == BiomeManager.BiomeType.DESERT || logged.contains(type) || WeightedRandom.func_76272_a((List)entries) > 0) continue;
            APIInfo.log.warn("Sum of biome generation weights for type " + type + " is zero! This will cause Vanilla generation to crash! You have been warned!");
            logged.add(type);
        }
        try {
            BiomeHelper.modTypeLists();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set type lists as modded!", e);
        }
    }

    @Override
    public Integer get(Object obj) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Can't get gen weight!");
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    @Override
    public Class<?> getTargetClass() {
        return Biome.class;
    }
}

