/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.script.pack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TypeBiomesPackage
extends BiomePackage {
    private final String[] sTypes;
    private BiomeDictionary.Type[] types;

    public TypeBiomesPackage(String ... types) {
        this.sTypes = types;
    }

    @Override
    public Iterator<Biome> getIterator() {
        this.checkTypes();
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (BiomeDictionary.Type type : this.types) {
            Set gens = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
            for (Biome gen : gens) {
                if (list.contains(gen)) continue;
                list.add(gen);
            }
        }
        return list.iterator();
    }

    @Override
    public List<Integer> getRawIds() {
        this.checkTypes();
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (BiomeDictionary.Type type : this.types) {
            Set gens = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
            for (Biome gen : gens) {
                ints.add(Biome.func_185362_a((Biome)gen));
            }
        }
        return ints;
    }

    @Override
    public boolean supportsEarlyRawIds() {
        return false;
    }

    private void checkTypes() {
        if (this.types == null) {
            BiomeDictionary.Type[] bTypes = new BiomeDictionary.Type[this.sTypes.length];
            for (int i = 0; i < this.sTypes.length; ++i) {
                bTypes[i] = BiomeDictionary.Type.getType((String)this.sTypes[i], (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            }
            this.types = bTypes;
        }
    }
}

