/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.common.control;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import wanion.biggercraftingtables.Reference;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.control.IState;
import wanion.lib.common.control.IStateNameable;
import wanion.lib.common.control.IStateProvider;

public class ShapeControl
implements IStateProvider<ShapeControl, ShapeState>,
IControlNameable {
    private ShapeState state;

    public ShapeControl() {
        this(ShapeState.SHAPED);
    }

    public ShapeControl(@Nonnull ShapeState state) {
        this.state = state;
    }

    @Nonnull
    public ShapeControl copy() {
        return new ShapeControl(this.state);
    }

    @Nonnull
    public ShapeState getState() {
        return this.state;
    }

    public void setState(@Nonnull ShapeState shapeState) {
        this.state = shapeState;
    }

    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound, @Nonnull ShapeState shapeState) {
        nbtTagCompound.func_74768_a("ShapeControl", shapeState.ordinal());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ShapeControl && this.state == ((ShapeControl)obj).state;
    }

    @Nonnull
    public String getControlName() {
        return "bigger.creating.shape.control";
    }

    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("ShapeControl", this.state.ordinal());
        return nbtTagCompound;
    }

    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ShapeControl")) {
            this.state = ShapeState.values()[MathHelper.func_76125_a((int)nbtTagCompound.func_74762_e("ShapeControl"), (int)0, (int)(ShapeState.values().length - 1))];
        }
    }

    public static enum ShapeState implements IState<ShapeState>,
    IStateNameable
    {
        SHAPED,
        SHAPELESS;


        @Nonnull
        public ShapeState getNextState() {
            int nextState = this.ordinal() + 1;
            return nextState > ShapeState.values().length - 1 ? ShapeState.values()[0] : ShapeState.values()[nextState];
        }

        @Nonnull
        public ShapeState getPreviousState() {
            int previousState = this.ordinal() - 1;
            return previousState >= 0 ? ShapeState.values()[previousState] : ShapeState.values()[ShapeState.values().length - 1];
        }

        public ResourceLocation getTextureResourceLocation() {
            return Reference.GUI_TEXTURES;
        }

        public Pair<Integer, Integer> getTexturePos(boolean b) {
            return new ImmutablePair((Object)(!b ? 0 : 19), (Object)(19 * this.ordinal()));
        }

        @Nonnull
        public String getStateName() {
            return "bigger.creating.shape.control.state." + this.name().toLowerCase();
        }

        public String getStateDescription() {
            return null;
        }
    }
}

