/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.common;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;
import wanion.biggercraftingtables.Reference;
import wanion.biggercraftingtables.block.TileEntityBiggerCreatingTable;
import wanion.biggercraftingtables.common.control.ShapeControl;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.Matching;
import wanion.lib.common.matching.MatchingController;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.NbtMatcher;

public final class CTUtils {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String TAB = "\t";

    private CTUtils() {
    }

    public static String toCTScript(@Nonnull TileEntityBiggerCreatingTable<?> tileEntityBiggerCreatingTable) {
        int outputSlot = tileEntityBiggerCreatingTable.func_70302_i_() - 1;
        ItemStack outputStack = tileEntityBiggerCreatingTable.func_70301_a(outputSlot);
        if (outputStack.func_190926_b()) {
            return null;
        }
        StringBuilder scriptBuilder = new StringBuilder();
        Reference.TableTypes tableType = tileEntityBiggerCreatingTable.getTableType();
        ShapeControl.ShapeState shapeState = tileEntityBiggerCreatingTable.getShapeControl().getState();
        scriptBuilder.append("mods.biggercraftingtables.");
        scriptBuilder.append(WordUtils.capitalizeFully((String)tableType.func_176610_l())).append(".add");
        scriptBuilder.append(shapeState == ShapeControl.ShapeState.SHAPED ? "Shaped" : "Shapeless").append('(');
        Matching outputMatching = new Matching(Collections.singletonList(outputStack), 0);
        if (outputStack.func_77942_o()) {
            outputMatching.setMatcher((AbstractMatcher)new NbtMatcher((AbstractMatching)outputMatching));
        }
        scriptBuilder.append(outputMatching.getMatcher().ctFormat());
        scriptBuilder.append(", [");
        MatchingController matchingController = tileEntityBiggerCreatingTable.getMatchingController();
        if (shapeState == ShapeControl.ShapeState.SHAPED) {
            int root = tileEntityBiggerCreatingTable.getRoot();
            int last = root - 1;
            for (int y = 0; y < root; ++y) {
                boolean hasNextY = y < last;
                scriptBuilder.append(NEW_LINE);
                scriptBuilder.append(TAB).append('[');
                for (int x = 0; x < root; ++x) {
                    boolean hasNextX = x < last;
                    int actualSlot = y * root + x;
                    if (!tileEntityBiggerCreatingTable.func_70301_a(actualSlot).func_190926_b()) {
                        AbstractMatching matchingControl = matchingController.getMatching(actualSlot);
                        scriptBuilder.append(matchingControl.getMatcher().ctFormat());
                        if (!hasNextX) continue;
                        scriptBuilder.append(", ");
                        continue;
                    }
                    scriptBuilder.append(hasNextX ? "null, " : "null");
                }
                scriptBuilder.append(hasNextY ? "]," : Character.valueOf(']'));
            }
            scriptBuilder.append(NEW_LINE);
            scriptBuilder.append(']');
        } else {
            int charPerLineCount = 0;
            TIntArrayList validList = new TIntArrayList();
            for (int i = 0; i < outputSlot; ++i) {
                if (tileEntityBiggerCreatingTable.func_70301_a(i).func_190926_b()) continue;
                validList.add(i);
            }
            TIntIterator validIterator = validList.iterator();
            while (validIterator.hasNext()) {
                String format = matchingController.getMatching(validIterator.next()).getMatcher().ctFormat();
                if ((charPerLineCount += format.length()) >= 320 && validIterator.hasNext()) {
                    scriptBuilder.deleteCharAt(scriptBuilder.length() - 1);
                    scriptBuilder.append(NEW_LINE).append(TAB);
                    charPerLineCount = 0;
                }
                scriptBuilder.append(format);
                if (!validIterator.hasNext()) continue;
                scriptBuilder.append(", ");
            }
            scriptBuilder.append(']');
        }
        scriptBuilder.append(");");
        scriptBuilder.append(NEW_LINE).append(NEW_LINE);
        return scriptBuilder.toString();
    }
}

