/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.party.PartyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetPartySync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:party_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetPartySync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetPartySync::onClient);
        }
    }

    public static void quickSync(int partyID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        IParty party = (IParty)PartyManager.INSTANCE.getValue(partyID);
        if (server == null || party == null) {
            return;
        }
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        for (UUID uuid : party.getMembers()) {
            EntityPlayerMP p = server.func_184103_al().func_177451_a(uuid);
            if (p == null) continue;
            players.add(p);
        }
        NetPartySync.sendSync(players.toArray(new EntityPlayerMP[0]), new int[]{partyID});
    }

    public static void sendSync(@Nullable EntityPlayerMP[] players, @Nullable int[] partyIDs) {
        if (partyIDs != null && partyIDs.length <= 0) {
            return;
        }
        if (players != null && players.length <= 0) {
            return;
        }
        NBTTagList dataList = new NBTTagList();
        List partySubset = partyIDs == null ? PartyManager.INSTANCE.getEntries() : PartyManager.INSTANCE.bulkLookup(partyIDs);
        for (DBEntry party : partySubset) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74768_a("partyID", party.getID());
            entry.func_74782_a("config", (NBTBase)((IParty)party.getValue()).writeToNBT(new NBTTagCompound()));
            dataList.func_74742_a((NBTBase)entry);
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74757_a("merge", partyIDs != null);
        if (players == null) {
            PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
        } else {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), players);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestSync(@Nullable int[] partyIDs) {
        NBTTagCompound payload = new NBTTagCompound();
        if (partyIDs != null) {
            payload.func_74783_a("partyIDs", partyIDs);
        }
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        NBTTagCompound payload = (NBTTagCompound)message.func_76341_a();
        int[] reqIDs = !payload.func_74764_b("partyIDs") ? null : payload.func_74759_k("partyIDs");
        NetPartySync.sendSync(new EntityPlayerMP[]{(EntityPlayerMP)message.func_76340_b()}, reqIDs);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        NBTTagList data = message.func_150295_c("data", 10);
        if (!message.func_74767_n("merge")) {
            PartyManager.INSTANCE.reset();
        }
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound tag = data.func_150305_b(i);
            if (!tag.func_150297_b("partyID", 99)) continue;
            int partyID = tag.func_74762_e("partyID");
            IParty party = (IParty)PartyManager.INSTANCE.getValue(partyID);
            if (party == null) {
                party = PartyManager.INSTANCE.createNew(partyID);
            }
            party.readFromNBT(tag.func_74775_l("config"));
        }
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.PARTY));
    }
}

